package com.common.demo.utils;

import android.content.Context;
import android.widget.ImageView;

import androidx.annotation.NonNull;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.luck.picture.lib.engine.ImageEngine;

public class GlideEngine implements ImageEngine {
    /**
     * 加载图片
     *
     * @param context
     * @param url
     * @param imageView
     */
    @Override
    public void loadImage(@NonNull Context context, @NonNull String url, @NonNull ImageView imageView) {
        Glide.with(context)
                .load(url)
                .into(imageView);
    }

    @Override
    public void loadImage(Context context, ImageView imageView, String url, int maxWidth, int maxHeight) {
        Glide.with(context)
                .load(url)
                .override(maxWidth, maxHeight)
                .into(imageView);
    }

    @Override
    public void loadAlbumCover(Context context, String url, ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .load(url)
                .override(180, 180)
                .sizeMultiplier(0.5f)
                .transform(new CenterCrop(), new RoundedCorners(8))
                .placeholder(com.luck.picture.lib.R.drawable.ps_image_placeholder)
                .into(imageView);
    }

    /**
     * 加载网络图片适配长图方案
     * # 注意：此方法只有加载网络图片才会回调
     *
     * @param context
     * @param url
     * @param imageView
     * @param longImageView
     * @param callback      网络图片加载回调监听 {link after version 2.5.1 Please use the #OnImageCompleteCallback#}
     */
//    @Override
//    public void loadImage(@NonNull Context context, @NonNull String url,
//                          @NonNull ImageView imageView,
//                          SubsamplingScaleImageView longImageView, OnImageCompleteCallback callback) {
//        Glide.with(context)
//                .asBitmap()
//                .load(url)
//                .into(new ImageViewTarget<Bitmap>(imageView) {
//                    @Override
//                    public void onLoadStarted(@Nullable Drawable placeholder) {
//                        super.onLoadStarted(placeholder);
//                        if (callback != null) {
//                            callback.onShowLoading();
//                        }
//                    }
//
//                    @Override
//                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
//                        super.onLoadFailed(errorDrawable);
//                        if (callback != null) {
//                            callback.onHideLoading();
//                        }
//                    }
//
//                    @Override
//                    protected void setResource(@Nullable Bitmap resource) {
//                        if (callback != null) {
//                            callback.onHideLoading();
//                        }
//                        if (resource != null) {
//                            boolean eqLongImage = MediaUtils.isLongImg(resource.getWidth(),
//                                    resource.getHeight());
//                            longImageView.setVisibility(eqLongImage ? View.VISIBLE : View.GONE);
//                            imageView.setVisibility(eqLongImage ? View.GONE : View.VISIBLE);
//                            if (eqLongImage) {
//                                // 加载长图
//                                longImageView.setQuickScaleEnabled(true);
//                                longImageView.setZoomEnabled(true);
//                                longImageView.setDoubleTapZoomDuration(100);
//                                longImageView.setMinimumScaleType(SubsamplingScaleImageView.SCALE_TYPE_CENTER_CROP);
//                                longImageView.setDoubleTapZoomDpi(SubsamplingScaleImageView.ZOOM_FOCUS_CENTER);
//                                longImageView.setImage(ImageSource.bitmap(resource),
//                                        new ImageViewState(0, new PointF(0, 0), 0));
//                            } else {
//                                // 普通图片
//                                imageView.setImageBitmap(resource);
//                            }
//                        }
//                    }
//                });
//    }

    /**
     * 加载网络图片适配长图方案
     * # 注意：此方法只有加载网络图片才会回调
     *
     * @param context
     * @param url
     * @param imageView
     * @param longImageView
     * @ 已废弃
     */
//    @Override
//    public void loadImage(@NonNull Context context, @NonNull String url,
//                          @NonNull ImageView imageView,
//                          SubsamplingScaleImageView longImageView) {
//        Glide.with(context)
//                .asBitmap()
//                .load(url)
//                .into(new ImageViewTarget<Bitmap>(imageView) {
//                    @Override
//                    protected void setResource(@Nullable Bitmap resource) {
//                        if (resource != null) {
//                            boolean eqLongImage = MediaUtils.isLongImg(resource.getWidth(),
//                                    resource.getHeight());
//                            longImageView.setVisibility(eqLongImage ? View.VISIBLE : View.GONE);
//                            imageView.setVisibility(eqLongImage ? View.GONE : View.VISIBLE);
//                            if (eqLongImage) {
//                                // 加载长图
//                                longImageView.setQuickScaleEnabled(true);
//                                longImageView.setZoomEnabled(true);
//                                longImageView.setDoubleTapZoomDuration(100);
//                                longImageView.setMinimumScaleType(SubsamplingScaleImageView.SCALE_TYPE_CENTER_CROP);
//                                longImageView.setDoubleTapZoomDpi(SubsamplingScaleImageView.ZOOM_FOCUS_CENTER);
//                                longImageView.setImage(ImageSource.bitmap(resource),
//                                        new ImageViewState(0, new PointF(0, 0), 0));
//                            } else {
//                                // 普通图片
//                                imageView.setImageBitmap(resource);
//                            }
//                        }
//                    }
//                });
//    }

    /**
     * 加载相册目录
     *
     * @param context   上下文
     * @param url       图片路径
     * @param imageView 承载图片ImageView
     */
//    @Override
//    public void loadFolderImage(@NonNull Context context, @NonNull String url, @NonNull ImageView imageView) {
//        Glide.with(context)
//                .asBitmap()
//                .load(url)
//                .override(180, 180)
//                .centerCrop()
//                .sizeMultiplier(0.5f)
//                .apply(new RequestOptions().placeholder(R.drawable.picture_image_placeholder))
//                .into(new BitmapImageViewTarget(imageView) {
//                    @Override
//                    protected void setResource(Bitmap resource) {
//                        RoundedBitmapDrawable circularBitmapDrawable =
//                                RoundedBitmapDrawableFactory.
//                                        create(context.getResources(), resource);
//                        circularBitmapDrawable.setCornerRadius(8);
//                        imageView.setImageDrawable(circularBitmapDrawable);
//                    }
//                });
//    }


    /**
     * 加载gif
     *
     * @param context   上下文
     * @param url       图片路径
     * @param imageView 承载图片ImageView
     */
//    @Override
//    public void loadAsGifImage(@NonNull Context context, @NonNull String url,
//                               @NonNull ImageView imageView) {
//        Glide.with(context)
//                .asGif()
//                .load(url)
//                .into(imageView);
//    }

    /**
     * 加载图片列表图片
     *
     * @param context   上下文
     * @param url       图片路径
     * @param imageView 承载图片ImageView
     */
    @Override
    public void loadGridImage(@NonNull Context context, @NonNull String url, @NonNull ImageView imageView) {
        Glide.with(context)
                .load(url)
                .override(200, 200)
                .centerCrop()
                .placeholder(com.luck.picture.lib.R.drawable.ps_image_placeholder)
                .into(imageView);
    }

    @Override
    public void pauseRequests(Context context) {
        Glide.with(context).pauseRequests();
    }

    @Override
    public void resumeRequests(Context context) {
        Glide.with(context).resumeRequests();
    }


    private GlideEngine() {
    }

    private static GlideEngine instance;

    public static GlideEngine createGlideEngine() {
        if (null == instance) {
            synchronized (GlideEngine.class) {
                if (null == instance) {
                    instance = new GlideEngine();
                }
            }
        }
        return instance;
    }
}
