package com.common.demo.utils

import android.app.Activity
import android.content.pm.PackageManager
import androidx.activity.result.contract.ActivityResultContracts
import androidx.core.content.ContextCompat

class PermissionHelper(private val activity: Activity? = null,
                       private val onResult: (granted: Boolean, deniedPermissions: List<String>) -> Unit) {
    private val launcher =
        (activity as? androidx.activity.ComponentActivity)
            ?.activityResultRegistry
            ?.register(
                "permission_request_${System.currentTimeMillis()}",
                ActivityResultContracts.RequestMultiplePermissions()
            ) { result ->
                val denied = result.filterValues { !it }.keys.toList()
                onResult(denied.isEmpty(), denied)
            }

    fun request(vararg permissions: String) {
        val context = activity ?: return
        val ungranted = permissions.filter {
            ContextCompat.checkSelfPermission(context, it) != PackageManager.PERMISSION_GRANTED
        }

        if (ungranted.isEmpty()) {
            onResult(true, emptyList())
        } else {
            launcher?.launch(ungranted.toTypedArray())
        }
    }
}