package com.common.demo.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import android.widget.Toast;

import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

/**
 * Created by NO on 2017/9/14.
 */

public class Utility {
    public static void checkBlueboothPermission(Activity context, String permission, String[] requestPermissions, Callback callback) {
        if (Build.VERSION.SDK_INT >= 23) {
            //校验是否已具有模糊定位权限
            if (ContextCompat.checkSelfPermission(context, permission) != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(context, requestPermissions, 100);
            } else {
                //具有权限
                callback.permit();
                return;
            }
        } else {
            //系统不高于6.0直接执行
            callback.permit();
        }
    }

    public interface Callback {
        /**
         * API>=23 允许权限
         */
        void permit();


    }

    public static Bitmap toBitmap(Bitmap bitmap, int width, int height) {
        Bitmap target = Bitmap.createBitmap(width, height, bitmap.getConfig());
        Canvas canvas = new Canvas(target);
        canvas.drawBitmap(bitmap, null, new Rect(0, 0, target.getWidth(), target.getHeight()), null);
        return target;
    }

    //width：目标宽度，pageWidthPoint：初始宽度，pageHeightPoint：初始高度
    public static int getHeight(int width, int pageWidthPoint, int pageHeightPoint) {
        double bili = width / (double) pageWidthPoint;
        return (int) (pageHeightPoint * bili);
    }

    public static Bitmap Tobitmap90(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        // 设置旋转角度
        matrix.setRotate(90);
        // 重新绘制Bitmap
        bitmap = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
        return bitmap;
    }

    //判断是否是整数
    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static void show(final Context context, final String message) {
        if (context == null || ((Activity) context).isFinishing()) {
            return;
        }
        ((Activity) context).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
            }
        });
    }

    public static File uriToFile(Context context, Uri uri){
        String docId = "";
        try {
            try {
                docId = DocumentsContract.getDocumentId(uri);
            }catch (Exception e){
                try {
                    docId = DocumentsContract.getTreeDocumentId(uri);
                }catch (Exception e1){
                    docId = "";}
            }
            String[] split = docId.split(":");
            String type = split[0];
            if(type.equals("primary")){
                return new File(Environment.getExternalStorageDirectory()+"/"+split[1]);
            }else{
                return new File(type);
            }
        }catch (Exception e){

        }
        return null;
    }

    public static File uriToFileApiQ(Uri uri, Context context) {
        File file = null;
        if(uri == null) return null;
        if(Build.VERSION.SDK_INT>Build.VERSION_CODES.P){
            //android10以上转换
            if (uri.getScheme().equals(ContentResolver.SCHEME_FILE)) {
                file = new File(uri.getPath());
            } else if (uri.getScheme().equals(ContentResolver.SCHEME_CONTENT)) {
                //把文件复制到沙盒目录
                ContentResolver contentResolver = context.getContentResolver();
                String displayName = "123"
                        +"."+ MimeTypeMap.getSingleton().getExtensionFromMimeType(contentResolver.getType(uri));
                try {
                    InputStream is = contentResolver.openInputStream(uri);
                    File cache = new File(context.getCacheDir().getAbsolutePath(), displayName);
                    FileOutputStream fos = new FileOutputStream(cache);
                    FileUtils.copy(is, fos);
                    file = cache;
                    fos.close();
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }else{
            file = new File(Objects.requireNonNull(getPath(context, uri)));
        }
        return file;
    }

    public static String getPath(final Context context, final Uri uri) {


        if (DocumentsContract.isDocumentUri(context, uri)) {
            if (isExternalStorageDocument(uri)) {
                final String docId = DocumentsContract.getDocumentId(uri);
                final String[] split = docId.split(":");
                final String type = split[0];

                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }

            }
            else if (isDownloadsDocument(uri)) {

                final String id = DocumentsContract.getDocumentId(uri);
                final Uri contentUri = ContentUris.withAppendedId(
                        Uri.parse("content://downloads/public_downloads"), Long.parseLong(id));

                return getDataColumn(context, contentUri, null, null);
            }
            else if (isMediaDocument(uri)) {
                final String docId = DocumentsContract.getDocumentId(uri);
                final String[] split = docId.split(":");
                final String type = split[0];

                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }

                final String selection = "_id=?";
                final String[] selectionArgs = new String[] {
                        split[1]
                };

                return getDataColumn(context, contentUri, selection, selectionArgs);
            }
        }
        else if ("content".equalsIgnoreCase(uri.getScheme())) {
            return getDataColumn(context, uri, null, null);
        }
        else if ("file".equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }

        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }


    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static String getDataColumn(Context context, Uri uri, String selection,
                                       String[] selectionArgs) {

        Cursor cursor = null;
        final String column = "_data";
        final String[] projection = {
                column
        };

        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs,
                    null);
            if (cursor != null && cursor.moveToFirst()) {
                final int column_index = cursor.getColumnIndexOrThrow(column);
                return cursor.getString(column_index);
            }
        } finally {
            if (cursor != null)
                cursor.close();
        }
        return null;
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }


    //file:PDF文件，
    //pageNumber:需要生成的页数，例如："1,2-3",
    //pageWidth:需要生成的宽度
    public static List<Bitmap> pdfToBitmap(Context context, File file, String pageNumber, int pageWidth) {
        ArrayList<Bitmap> ListBitmap = new ArrayList<>();
        PdfiumCore pdfiumCore = new PdfiumCore(context);
        try {
            ArrayList<String> list = new ArrayList<>();
            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open(file, ParcelFileDescriptor.MODE_READ_ONLY);
            PdfDocument pdfDocument = pdfiumCore.newDocument(parcelFileDescriptor);
            int pages = pdfiumCore.getPageCount(pdfDocument);
            String[] split = pageNumber.split(",");
            for (String s : split) {
                String[] split2 = s.split("-");
                if (split2.length == 2) {
                    int bigPage = Integer.parseInt(split2[1]);
                    int smallPage = Integer.parseInt(split2[0]);
                    int page = bigPage - smallPage;
                    for (int j = 0; j < page + 1; j++) {
                        if (!list.contains("" + (smallPage + j))) {
                            list.add("" + (smallPage + j));
                        }
                    }
                } else {
                    if (!list.contains(split2[0])) {
                        list.add(split2[0]);
                    }
                }
            }
            int height;
            if (list.size() == 0)
                return ListBitmap;
            for (int pageIndex = 0; pageIndex < list.size(); pageIndex++) {
                int page = Integer.parseInt(list.get(pageIndex));
                if (0 < page && page <= pages) {
                    pdfiumCore.openPage(pdfDocument, page - 1);
                    int pageWidthPoint = pdfiumCore.getPageWidthPoint(pdfDocument, page - 1);
                    int pageHeightPoint = pdfiumCore.getPageHeightPoint(pdfDocument, page - 1);
                    double bili = pageWidth / (double) pageWidthPoint;
                    height = (int) (pageHeightPoint * bili);
                    Bitmap bitmap = Bitmap.createBitmap(pageWidth, height, Bitmap.Config.ARGB_8888);
                    pdfiumCore.renderPageBitmap(pdfDocument, bitmap, page - 1, 0, 0, pageWidth, height);
                    ListBitmap.add(bitmap);
                }
            }
            pdfiumCore.closeDocument(pdfDocument);
        } catch (Exception e) {
            return ListBitmap;
        }
        return ListBitmap;
    }
//    public static List<Bitmap> pdfToBitmap(Context context, File file, String pageNumber, int pageWidth) {
//        ArrayList<Bitmap> ListBitmap = new ArrayList<>();
//        try {
//            ArrayList<String> list = new ArrayList<>();
//            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open(file, ParcelFileDescriptor.MODE_READ_ONLY);
//            PdfiumCore pdfiumCore = new PdfiumCore(context);
//            PdfDocument pdfDocument = pdfiumCore.newDocument(parcelFileDescriptor);
//            int pages = pdfiumCore.getPageCount(pdfDocument);
//            String[] split = pageNumber.split(",");
//            for (String s : split) {
//                String[] split2 = s.split("-");
//                if (split2.length == 2) {
//                    int bigPage = Integer.parseInt(split2[1]);
//                    int smallPage = Integer.parseInt(split2[0]);
//                    int page = bigPage - smallPage;
//                    for (int j = 0; j < page + 1; j++) {
//                        if (!list.contains("" + (smallPage + j))) {
//                            list.add("" + (smallPage + j));
//                        }
//                    }
//                } else {
//                    if (!list.contains(split2[0])) {
//                        list.add(split2[0]);
//                    }
//                }
//            }
//            int height;
//            if (list.size() == 0)
//                return ListBitmap;
//            for (int pageIndex = 0; pageIndex < list.size(); pageIndex++) {
//                int page = Integer.parseInt(list.get(pageIndex));
//                if (0 < page && page <= pages) {
//                    pdfiumCore.openPage(pdfDocument, page - 1);
//                    int pageWidthPoint = pdfiumCore.getPageWidthPoint(pdfDocument, page - 1);
//                    int pageHeightPoint = pdfiumCore.getPageHeightPoint(pdfDocument, page - 1);
//                    double bili = pageWidth / (double) pageWidthPoint;
//                    height = (int) (pageHeightPoint * bili);
//                    Bitmap bitmap = Bitmap.createBitmap(pageWidth, height, Bitmap.Config.ARGB_8888);
//                    pdfiumCore.renderPageBitmap(pdfDocument, bitmap, page - 1, 0, 0, pageWidth, height, true);
//                    ListBitmap.add(bitmap);
//                }
//            }
//            pdfiumCore.closeDocument(pdfDocument);
//        } catch (Exception e) {
//            return ListBitmap;
//        }
//        return ListBitmap;
//    }
}
