//
//  HTSPLViewController.m
//  HDemo
//
//  Created by ios on 2020/9/28.
//  Copyright © 2020 Printer. All rights reserved.
//

#import "HTSPLViewController.h"
#import "HConst.h"
#import "HTSPLFunctions.h"

@interface HTSPLViewController ()<UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *functions;

@end

@implementation HTSPLViewController


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.backgroundColor = [UIColor whiteColor];
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
    }
    return _tableView;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.navigationItem.title = @"TSPL function".localized;
    self.functions = @[@"Device Status Sample".localized,@"Self-test page Sample".localized,@"Vector text Sample".localized,@"Dot Matrix text Sample".localized,@"Barcode Sample".localized,@"Bitmap Sample".localized];
    
    [self.view addSubview:self.tableView];
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.mas_equalTo(0);
        make.bottom.mas_equalTo(-kSafeAreaBottomHeight);
    }];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0.01;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0.01;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.functions.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"idea"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"idea"];
    }
    
    cell.textLabel.text = self.functions[indexPath.row];
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    switch (indexPath.row) {
    case 0:
        [HTSPLFunctions testPrinterStatus];
        break;
    case 1:
        [HTSPLFunctions testPrintSelfpage];
        break;
    case 2:
        [HTSPLFunctions testPrinterVectorText];
        break;
    case 3:
        [HTSPLFunctions testPrintDotMatrixText];
        break;
    case 4:
        [HTSPLFunctions testPrintBarcode];
        break;
    case 5:
        [HTSPLFunctions testPrintImage];
        break;
    default:
        break;
    }
}

@end
