//
//  CPCLVectorTextViewController.swift
//  PrinterDemo
//
//  Created by Wencai Luo on 2022/11/14.
//  Copyright © 2022 ChinaPL. All rights reserved.
//

import UIKit
import SwifterBaseKit

class CPCLVectorTextViewController: PDBaseViewController {

    @IBOutlet weak var textView: UITextView!

    @IBOutlet weak var fontTypeLb: UILabel!
    
    @IBOutlet weak var fontTF: UILabel!
    
    @IBOutlet weak var sendButton: UIButton!
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        
    }

    override func configUI() {
        navigationItem.title = "Vector text Sample".localized
        
        textView.addBackView()
        textView.clipsToBounds = true
        textView.layer.cornerRadius = 10
        textView.layer.borderColor = UIColor.theme.cgColor
        textView.layer.borderWidth = 0.5
        
        fontTF.clipsToBounds = true
        fontTF.layer.cornerRadius = 10
        fontTF.layer.borderColor = UIColor.theme.cgColor
        fontTF.layer.borderWidth = 0.5
        fontTypeLb.text = "Font type".localized
        
        sendButton.titleForNormal = "Send".localized
        sendButton.cornerRadius = 10
        sendButton.backgroundColor = UIColor.theme
        
        fontTF.text = "SIMSUN.TTF"
    }
    
    
    @IBAction func selectFontAction(_ sender: Any) {
        let fontArray = ["SIMSUN.TTF","TT0003M_.TTF"]
        let pickerView = PDPickerView.init(with:fontArray)
        kAppWindow.addSubview(pickerView)
        pickerView.selectItemClosure = { [weak self](item) in
            guard let self = self else { return }
            self.fontTF.text = item
        }
    }
    
    
    @IBAction func didSendDataAction(_ sender: Any) {
        
        guard let temp = textView.text else {
            return
        }
        if temp.isEmpty {
            return
        }
        let height = temp.drawHeight(with: kScreenWidth - 50, font: UIFont.systemFont(ofSize: 16))
        
        let cmd = PTCommandCPCL.init()
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: Int(height) + 100, quantity: 1)
        cmd.cpclPageWidth(kUserDefaults.integer(forKey: PDPrintDots))
        
        cmd.cpclTrueTypeText(fontTF.text!, xScale: 20, yScale: 20, x: 0, y: 0, text: temp)
        
        if kUserDefaults.bool(forKey: PDPaperType) {
            cmd.cpclForm()
        }
        cmd.cpclPrint()
        PDManagerSendData.shared.sendDataToPeripheral(data: cmd.cmdData as Data, true)
    }
    
}
