//
//  PDESCViewController.swift
//  PrinterDemo
//
//  Created by ios on 2019/10/28.
//  Copyright © 2019 Printer. All rights reserved.
//

import UIKit
import SVProgressHUD
import PrinterSDK
import UniformTypeIdentifiers
import MobileCoreServices

class PDESCViewController: PDBaseViewController {
    
    lazy var tableView : UITableView = {
        let temp = UITableView.init(frame: .zero, style: .plain)
        temp.delegate = self
        temp.dataSource = self
        temp.backgroundColor = .white
        temp.rowHeight = 50.0
        temp.showsVerticalScrollIndicator = false
        temp.separatorStyle = UITableViewCell.SeparatorStyle.singleLine
        return temp
    }()
    
    private var functions = [PDSettingItem]()
    var selectDocumentType = PDDocumentPickerView.commandDocument
    var info = [(key: String,value: String)]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        navigationItem.title = "ESC function".localized
        
        view.addSubview(tableView)
        tableView.snp.makeConstraints {
            $0.edges.equalTo(self.view.usnp.edges)
        }
        
        loadDataSource()
    }
    
    private func loadDataSource() {
        
        functions.removeAll()
        var item : PDSettingItem
        
        item = PDSettingItem.init(title: "Custom text Sample".localized, detailTitle: nil, target: self, selector: #selector(pushAutoTextVC))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Self-test page Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.printSelfTestPage))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Device Status Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.getPrinterStatus))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Barcode Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.printBarcode))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Page Mode Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.testPageModeSample))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Bill Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.testBillSample))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Bitmap Sample".localized, detailTitle: nil, target: self, selector: #selector(self.pushSystenPhoto))
        functions.append(item)
        
        item = PDSettingItem.init(title: "PDF Print".localized, detailTitle: nil, target: self, selector: #selector(self.selectPDFFiles))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Command File Print".localized, detailTitle: nil, target: self, selector: #selector(self.selectDocument))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Printer firmware upgrade".localized, detailTitle: nil, target: self, selector: #selector(self.updateDeviceFirmware))
        functions.append(item)
        
        item = PDSettingItem.init(title: "POS Bill Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.testPOSPrinterSample))
        functions.append(item)
        
        item = PDSettingItem.init(title: "POS Image Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.testPOSImageSample))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Set the siyuan bold(Chinese)".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.setSesFontForChinese))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Set the siyuan bold(English)".localized, detailTitle: nil, target: nil, selector: #selector(PDESCTestFunctions.setSesFontForEnglish))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Configure network parameters".localized, detailTitle: nil, target: self, selector: #selector(self.configWiFiParaInfo))
        functions.append(item)
    }
    
}

extension PDESCViewController : UITableViewDelegate,UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return functions.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        var cell = tableView.dequeueReusableCell(withIdentifier: "iden")
        if cell == nil {
            cell = UITableViewCell.init(style: UITableViewCell.CellStyle.subtitle, reuseIdentifier: "iden")
        }
        cell?.textLabel?.text = functions[indexPath.row].title
        cell?.textLabel?.textColor = UIColor.black
        
        return cell!
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        
        let action = functions[indexPath.row]
        if let target = action.target {
            if let selector = action.selector {
                target.perform(selector)
            }
        }else {
            if let selector = action.selector {
                PDESCTestFunctions.perform(selector)
            }
        }
    }
}

extension PDESCViewController {
        
    @objc func configWiFiParaInfo() {
        self.navigationController?.pushViewController(PDConfigWiFiParaController(), animated: true)
    }
    
    func showInfo() {
        if info.count > 0 {
            let message = info.map({ "\($0.key): \($0.value)" }).joined(separator: "\n")
            self.bk_presentWarningAlertController(title: "Receive message".localized, message: message, style: .default)
        }
        info = []
    }
}

extension PDESCViewController {
    
    @objc func pushAutoTextVC() {
        
        self.navigationController?.pushViewController(PDPrintTextViewController(with: PTCommandType.ESC), animated: true)
    }
    
    //MARK:print image
    @objc func pushSystenPhoto() {
        
        let photoPickerVC = PDPhotoListViewController.init(with: PTCommandType.ESC)
        navigationController?.pushViewController(photoPickerVC, animated: true)
    }
    
    @objc private func selectDocument() {
        
        self.selectDocumentType = PDDocumentPickerView.commandDocument
        let picker = UIDocumentPickerViewController.init(documentTypes: ["public.data"], in: .import)
        picker.delegate = self
        picker.modalPresentationStyle = .fullScreen
        self.present(picker, animated: true, completion: nil)
    }
    
    @objc private func updateDeviceFirmware() {
        
        UIAlertController.showActionAlert("Tips".localized, message: "This function is only for some models, please confirm whether your printer supports the function, if it supports, please select the printer firmware to upgrade".localized, confirm: "OK".localized) { (_) in
            self.selectDocumentType = PDDocumentPickerView.firmwareBin
            var picker: UIDocumentPickerViewController
            if #available(iOS 14, *) {
                picker = UIDocumentPickerViewController.init(
                    forOpeningContentTypes: [
                        UTType.init(tag: "bin", tagClass: UTTagClass.filenameExtension, conformingTo: UTType.data)!
                    ], asCopy: true)
            }else {
                picker = UIDocumentPickerViewController.init(documentTypes: ["public.data"], in: .import)
            }
            picker.delegate = self
            picker.navigationController?.navigationBar.isTranslucent = false
            picker.modalPresentationStyle = .fullScreen
            picker.modalTransitionStyle = .crossDissolve
            self.present(picker, animated: true, completion: nil)
        }
    }
    
    @objc private func selectPDFFiles() {
        var picker: UIDocumentPickerViewController
        if #available(iOS 14, *) {
            picker = UIDocumentPickerViewController.init(
                forOpeningContentTypes: [
                    UTType.init(tag: "pdf", tagClass: UTTagClass.filenameExtension, conformingTo: UTType.data)!
                ], asCopy: true)
        }else {
            picker = UIDocumentPickerViewController.init(documentTypes: ["public.data"], in: .import)
        }

        self.selectDocumentType = PDDocumentPickerView.pdf
        picker.delegate = self
        picker.modalPresentationStyle = .overFullScreen
        self.present(picker, animated: true, completion: nil)
    }
}

extension PDESCViewController: UIDocumentPickerDelegate {
    
    func documentPicker(_ controller: UIDocumentPickerViewController, didPickDocumentAt url: URL) {
        
        sendData(from: url)
    }
    
    func documentPicker(_ controller: UIDocumentPickerViewController, didPickDocumentsAt urls: [URL]) {
        
        sendData(from: urls[0])
    }
    
    func sendData(from url: URL) -> Void {
        
        switch self.selectDocumentType {
            case .commandDocument:
                self.selectCmdPrint(url)
            case .firmwareBin:
                self.updatePrinterFirmware(url)
            case .pdf:
                self.selectPDFPrint(url, .ESC)

        }
    }
}
