//
//  TSPLAlignmentViewController.swift
//  PrinterDemo
//
//  Created by Wencai Luo on 2022/8/18.
//  Copyright © 2022 ChinaPL. All rights reserved.
//

import UIKit
import PrinterSDK
import SwifterBaseKit

class TSPLAlignmentViewController: PDBaseViewController {
    
    @IBOutlet weak var textView: UITextView!
    @IBOutlet weak var fontTypeLb: UILabel!
    @IBOutlet weak var textAlignLb: UILabel!
    @IBOutlet weak var fontTypeTF: UILabel!
    @IBOutlet weak var sendButton: UIButton!
    @IBOutlet weak var alignSegment: UISegmentedControl!
    
    var x_multi = 1
    var y_multi = 1
    
    var alignment = PTTSCTextAlignment.left
    
    var font = PTTSCTextVectorFontStyle.style0 {
        didSet {
            switch self.font {
            case .style0:
                fontTypeTF.text = "font type:0".localized
                x_multi = 1
                y_multi = 1
            case .style1:
                fontTypeTF.text = "font type:1".localized
                x_multi = 1
                y_multi = 1
            case .style2:
                fontTypeTF.text = "font type:2".localized
                x_multi = 1
                y_multi = 1
            case .style3:
                fontTypeTF.text = "font type:3".localized
                x_multi = 1
                y_multi = 1
            case .style4:
                fontTypeTF.text = "font type:4".localized
                x_multi = 1
                y_multi = 1
            case .style5:
                fontTypeTF.text = "font type:5".localized
                x_multi = 1
                y_multi = 1
            case .style6:
                fontTypeTF.text = "font type:6".localized
                x_multi = 1
                y_multi = 1
            case .style7:
                fontTypeTF.text = "font type:7".localized
                x_multi = 1
                y_multi = 1
            case .style8:
                fontTypeTF.text = "font type:8".localized
                x_multi = 1
                y_multi = 1
            case .style9:
                fontTypeTF.text = "font type:9".localized
                x_multi = 40
                y_multi = 40
            @unknown default:
                fatalError()
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        navigationItem.title = "Aligned text Sample".localized
    }
    
    override func configUI() {
        textView.addBackView()
        textView.clipsToBounds = true
        textView.layer.cornerRadius = 10
        textView.layer.borderColor = UIColor.theme.cgColor
        textView.layer.borderWidth = 0.5
        
        fontTypeTF.clipsToBounds = true
        fontTypeTF.layer.cornerRadius = 10
        fontTypeTF.layer.borderColor = UIColor.theme.cgColor
        fontTypeTF.layer.borderWidth = 0.5
        fontTypeLb.text = "Font type".localized
        textAlignLb.text = "Alignment".localized
        
        sendButton.titleForNormal = "Send".localized
        sendButton.cornerRadius = 10
        sendButton.backgroundColor = UIColor.theme
        
        alignSegment.setTitle("Left".localized, forSegmentAt: 0)
        alignSegment.setTitle("Center".localized, forSegmentAt: 1)
        alignSegment.setTitle("Right".localized, forSegmentAt: 2)
        alignSegment.selectedSegmentIndex = 0
        if #available(iOS 13, *) {
            alignSegment.selectedSegmentTintColor = UIColor.theme
        }else {
            alignSegment.tintColor = UIColor.theme
        }
        alignSegment.setTitleTextAttributes([NSAttributedString.Key.font:UIFont.systemFont(ofSize: 14),NSAttributedString.Key.foregroundColor:UIColor.black], for: UIControl.State.normal)
        alignSegment.setTitleTextAttributes([NSAttributedString.Key.font:UIFont.systemFont(ofSize: 14),NSAttributedString.Key.foregroundColor:UIColor.white], for: UIControl.State.selected)
        
        font = .style1
    }
    
    @IBAction func alignmentValueChange(_ sender: UISegmentedControl) {
        if sender.selectedSegmentIndex == 0 {
            alignment = .left
        }else if sender.selectedSegmentIndex == 1 {
            alignment = .center
        }else {
            alignment = .right
        }
    }
    
    @IBAction func didSelectFontAction(_ sender: Any) {
        var fontArray = [String]()
        for i in 0...9 {
            fontArray.append("font type:\(i)".localized)
        }
        let pickerView = PDPickerView.init(with: fontArray)
        kAppWindow.addSubview(pickerView)
        pickerView.selectItemClosure = {[weak self] (item) in
            guard let self = self else { return }
            switch item {
            case "font type:0".localized:
                self.font = .style0
            case "font type:1".localized:
                self.font = PTTSCTextVectorFontStyle.style1
            case "font type:2".localized:
                self.font = PTTSCTextVectorFontStyle.style2
            case "font type:3".localized:
                self.font = PTTSCTextVectorFontStyle.style3
            case "font type:4".localized:
                self.font = PTTSCTextVectorFontStyle.style4
            case "font type:5".localized:
                self.font = PTTSCTextVectorFontStyle.style5
            case "font type:6".localized:
                self.font = PTTSCTextVectorFontStyle.style6
            case "font type:7".localized:
                self.font = PTTSCTextVectorFontStyle.style7
            case "font type:8".localized:
                self.font = PTTSCTextVectorFontStyle.style8
            case "font type:9".localized:
                self.font = PTTSCTextVectorFontStyle.style9
            default:
                break
            }
        }
    }
    

    @IBAction func sendDataAction(_ sender: Any) {
        view.endEditing(true)
        
        guard let tv = textView.text else { return }
        let textHeight = tv.drawHeight(with: CGFloat(MAXFLOAT), font: UIFont.systemFont(ofSize: 15))
        
        let cmd = PTCommandTSPL.init()
        cmd.setCLS()
        cmd.setPrintDirection(PTTSCPrintDirection.reverse, mirror: PTTSCPrintStyle.normal)
        cmd.setPrintAreaSizeWithWidth(kUserDefaults.integer(forKey: PDPrintDots) / 8, height: 10 + Int(textHeight/8 + 1))
        cmd.appendTextForVector(withXpos: 10, yPos: 10, font: font, rotation: PTTSCStyleRotation.rotation0, xMultiplication: x_multi, yMultiplication: y_multi, alginment: alignment, text: tv)
        cmd.print(withSets: 1, copies: 1)
        PDManagerSendData.shared.sendDataToPeripheral(data: cmd.cmdData as Data, true)
    }
    

}
