//
//  PDZPLViewController.swift
//  PrinterDemo
//
//  Created by ldc on 2019/10/25.
//  Copyright © 2019 Printer. All rights reserved.
//

import UIKit
import PrinterSDK
import SVProgressHUD
import UniformTypeIdentifiers
import MobileCoreServices

class PDZPLViewController: PDBaseViewController {

    lazy var tableView : UITableView = {
        let temp = UITableView.init(frame: .zero, style: .plain)
        temp.delegate = self
        temp.dataSource = self
        temp.backgroundColor = .white
        temp.rowHeight = 50.0
        temp.showsVerticalScrollIndicator = false
        temp.separatorStyle = UITableViewCell.SeparatorStyle.singleLine
        return temp
    }()
    
    private var docuemntType = PDDocumentPickerView.pdf
    private var functions = [PDSettingItem]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        navigationItem.title = "ZPL function".localized
        
        view.addSubview(tableView)
        tableView.snp.makeConstraints {
            $0.edges.equalTo(self.view.usnp.edges)
        }
        
        loadDataSource()
    }
    
    private func loadDataSource() {
        
        functions.removeAll()
        var item : PDSettingItem
        
        item = PDSettingItem.init(title: "Self-test page Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.printSelfTestPage))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Text Sample1".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.testPrinterText1))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Text Sample2".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.testPrinterText2))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Font Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.testPrinterFont))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Barcode Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.testAllBarcode))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Graphics Sample".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.printGraphics))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Bitmap Sample".localized, detailTitle: nil, target: self, selector: #selector(self.pushSystenPhoto))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Command File Print".localized, detailTitle: nil, target: self, selector: #selector(self.pickDocument))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Paper cutting sample".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.testPaperCut))
        functions.append(item)
        
        item = PDSettingItem.init(title: "Stripper example".localized, detailTitle: nil, target: nil, selector: #selector(PDZPLTestFunctions.testStripper))
        functions.append(item)
        
        item = PDSettingItem.init(title: "PDF Print".localized, detailTitle: nil, target: self, selector: #selector(self.selectPDFFiles))
        functions.append(item)
    }
    
    @objc private func testRFID() {
        navigationController?.pushViewController(PDRFIDViewController(with: .ZPL), animated: true)
    }

    //MARK:print image
    @objc func pushSystenPhoto() {
        
        let photoPickerVC = PDPhotoListViewController.init(with: PTCommandType.ZPL)
        navigationController?.pushViewController(photoPickerVC, animated: true)
    }
    
    @objc func pickDocument() {
        
        let picker = UIDocumentPickerViewController.init(documentTypes: ["public.data"], in: .import)
        self.docuemntType = PDDocumentPickerView.commandDocument
        picker.delegate = self
        picker.modalPresentationStyle = .fullScreen
        self.present(picker, animated: true, completion: nil)
    }
    
    @objc private func selectPDFFiles() {
        
        var picker: UIDocumentPickerViewController
        if #available(iOS 14, *) {
            picker = UIDocumentPickerViewController.init(
                forOpeningContentTypes: [
                    UTType.init(tag: "pdf", tagClass: UTTagClass.filenameExtension, conformingTo: UTType.data)!
                ], asCopy: true)
        }else {
            picker = UIDocumentPickerViewController.init(documentTypes: ["public.data"], in: .import)
        }

        self.docuemntType = PDDocumentPickerView.pdf
        picker.delegate = self
        picker.modalPresentationStyle = .overFullScreen
        self.present(picker, animated: true, completion: nil)
    }
}

extension PDZPLViewController: UIDocumentPickerDelegate {
    
    func documentPicker(_ controller: UIDocumentPickerViewController, didPickDocumentAt url: URL) {
        
        sendData(from: url)
    }
    
    func documentPicker(_ controller: UIDocumentPickerViewController, didPickDocumentsAt urls: [URL]) {
        
        sendData(from: urls[0])
    }
    
    func sendData(from url: URL) -> Void {
        
        switch self.docuemntType {
            case .commandDocument:
                self.selectCmdPrint(url)
            case .firmwareBin:
                self.updatePrinterFirmware(url)
            case .pdf:
                self.selectPDFPrint(url, .ZPL)
        }
    }
}

extension PDZPLViewController : UITableViewDelegate,UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return functions.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        var cell = tableView.dequeueReusableCell(withIdentifier: "iden")
        if cell == nil {
            cell = UITableViewCell.init(style: UITableViewCell.CellStyle.subtitle, reuseIdentifier: "iden")
        }
        cell?.textLabel?.text = functions[indexPath.row].title
        cell?.textLabel?.textColor = UIColor.black
        
        return cell!
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        
        let action = functions[indexPath.row]
        if let target = action.target {
            if let selector = action.selector {
                target.perform(selector)
            }
        }else {
            if let selector = action.selector {
                PDZPLTestFunctions.perform(selector)
            }
        }
    }
}
