//
//  PDMacro.swift
//  PrinterDemo
//
//  Created by ios on 2019/9/5.
//  Copyright © 2019 Printer. All rights reserved.
//

import Foundation
import SnapKit
import UIKit
import SwifterBaseKit



let kUserDefaults = UserDefaults.standard



func DLog<T>(message : T,file : String = #file,function:String = #function, lineNumber : Int = #line) {
    #if DEBUG
    let fileName = (file as NSString).lastPathComponent
    print("Log：[\(fileName) | \(function) | lineNum:\(lineNumber)] \n \(message)")
    #endif
}

func kRGBCOLOR(r:CGFloat,g:CGFloat,b:CGFloat) -> UIColor{
    return UIColor(red:  r/255.0, green: g/255.0, blue:  b/255.0, alpha: 1)
}

func kRGBACOLOR(r:CGFloat,g:CGFloat,b:CGFloat, a:CGFloat) -> UIColor{
    return UIColor(red:  r/255.0, green: g/255.0, blue:  b/255.0, alpha: a)
}

//RGB 16进制转换
func KRGBHEXCOLOR(rgbValue: UInt) -> UIColor {
    return UIColor(
        red: CGFloat((rgbValue & 0xFF0000) >> 16) / 255.0,
        green: CGFloat((rgbValue & 0x00FF00) >> 8) / 255.0,
        blue: CGFloat(rgbValue & 0x0000FF) / 255.0,
        alpha: CGFloat(1.0)
    )
}



//MARK: SnapKit
extension ConstraintView {
    
    var usnp: ConstraintBasicAttributesDSL {
        if #available(iOS 11.0, *) {
            return self.safeAreaLayoutGuide.snp
        } else {
            return self.snp
        }
    }
}

public let PDPaperType = "PD_PAPER_TYPE"
public let PDWiFiIP = "PD_WIFI_IP"
public let PDPrintDots = "PDPrintDots"
