//
//  PTDispatcher+.swift
//  PrinterDemo
//
//  Created by ldc on 2024/9/12.
//  Copyright © 2024 ChinaPL. All rights reserved.
//

import Foundation
import SVProgressHUD

extension PTDispatcher {
    
    func hprt_writeData(
        data: Data,
        progress: ((Float) -> Void)? = nil,
        complete: ((Bool) -> Void)? = nil
    ) -> Void {
        
        send(data)
        whenSendFailure({
            complete?(false)
        })
        
        whenSendProgressUpdate({
            if let value = $0?.floatValue {
                progress?(value)
            }
        })
        
        whenSendSuccess({ _,_ in
            SVProgressHUD.showSuccess(withStatus: "Data sent successfully".localized)
            complete?(true)
        })
        
        whenReceiveData({ (data) in
            guard let data = data else {return}
            print(#line,data.hexString)
        })
    }
}
