package com.sdk.tspl.demo;


import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.luck.picture.lib.utils.ToastUtils;
import com.prt.tspl.log.Log;
import com.prt.tspl.printer.PrinterTSPL;

import java.util.Iterator;


public class Activity_1DBarcodes extends AppCompatActivity {
    private Context thisCon = null;
    private Spinner spnBarcodeType = null;
    private EditText txtBarcodeData = null;
    private EditText txtBarcodeHeight = null;
    private EditText txtBarcode_x = null;
    private EditText txtBarcode_y = null;
    private int BarcodeWidth = 2;
    private int mBarcodeReadable = 0;
    private int mBarcodeRotation = 0;
    private int mBarcodeNarrow = 0;
    private String mBarcodeType;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_1dbarcodes);
        thisCon = this.getApplicationContext();
        spnBarcodeType = findViewById(R.id.spnBarcodeType);
        ArrayAdapter<CharSequence> arrBarcodeType = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_barcode_type, android.R.layout.simple_spinner_item);
        arrBarcodeType.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcodeType.setAdapter(arrBarcodeType);
        spnBarcodeType.setOnItemSelectedListener(new OnItemSelectedBarcodeType());

        Spinner spnBarcodeWidth = findViewById(R.id.spnBarcodeWidth);
        ArrayAdapter<CharSequence> arrBarcodeWidth = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_width, android.R.layout.simple_spinner_item);
        arrBarcodeWidth.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcodeWidth.setAdapter(arrBarcodeWidth);
        spnBarcodeWidth.setOnItemSelectedListener(new OnItemSelectedBarcodeWidth());

        Spinner spnBarcode_readable = findViewById(R.id.spnBarcode_readable);
        ArrayAdapter<CharSequence> arrBarcodeHRILayout = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_hri_position, android.R.layout.simple_spinner_item);
        arrBarcodeHRILayout.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcode_readable.setAdapter(arrBarcodeHRILayout);
        spnBarcode_readable.setOnItemSelectedListener(new OnItemSelectedBarcodeHRILayout());

        Spinner spnBarcode_rotation = findViewById(R.id.spnBarcode_rotation);
        ArrayAdapter<CharSequence> arrBarcodeRotation = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_hri_rotation, android.R.layout.simple_spinner_item);
        arrBarcodeRotation.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcode_rotation.setAdapter(arrBarcodeRotation);
        spnBarcode_rotation.setOnItemSelectedListener(new OnItemSelectedBarcodeRotation());

        Spinner spnBarcode_narrow = findViewById(R.id.spnBarcode_narrow);
        ArrayAdapter<CharSequence> arrBarcodeNarrow = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_width, android.R.layout.simple_spinner_item);
        arrBarcodeNarrow.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcode_narrow.setAdapter(arrBarcodeNarrow);
        spnBarcode_narrow.setOnItemSelectedListener(new OnItemSelectedBarcodeNarrow());

        txtBarcodeData = this.findViewById(R.id.txtBarcodeData);
        txtBarcodeHeight = this.findViewById(R.id.txtBarcodeHeight);
        txtBarcode_x = this.findViewById(R.id.txtBarcode_x);
        txtBarcode_y = this.findViewById(R.id.txtBarcode_y);

    }

    private class OnItemSelectedBarcodeType implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mBarcodeType = spnBarcodeType.getSelectedItem().toString();
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedBarcodeWidth implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            BarcodeWidth = arg2 + 2;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedBarcodeHRILayout implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mBarcodeReadable = arg2;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedBarcodeRotation implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mBarcodeRotation = arg2 * 90;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedBarcodeNarrow implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mBarcodeNarrow = arg2 + 2;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }


    public void onClickPrint(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            if (txtBarcodeData.getText().toString().trim().length() == 0) {
                Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_no_data), Toast.LENGTH_SHORT).show();
                return;
            }
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                if (printer.printAreaSize("100", "80") == -1) {
                    printerSendFail(iterator, printer);
                    return;
                }
                printer.cls();
                printer.printBarcode(txtBarcode_x.getText().toString(), txtBarcode_y.getText().toString(), mBarcodeType, txtBarcodeHeight.getText().toString(), "" + mBarcodeReadable, "" + mBarcodeRotation, "" + mBarcodeNarrow, "" + BarcodeWidth, txtBarcodeData.getText().toString().trim());
                printer.print("1", "1");
            }
        } catch (Exception e) {
            Log.e("Activity_1DBarcodes --> onClickPrint " + e.getMessage());
        }
    }
    private void printerSendFail(Iterator<PrinterTSPL> iterator, PrinterTSPL printer) {
        ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        iterator.remove();
    }
}