package com.sdk.tspl.demo;

import static android.app.PendingIntent.FLAG_MUTABLE;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.prt.tspl.log.Log;

import android.util.Printer;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import com.blankj.utilcode.util.LogUtils;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.utils.ToastUtils;
import com.prt.tspl.PrinterHelper;
import com.prt.tspl.constant.Constants;
import com.prt.tspl.printer.PrinterTSPL;
import com.tbruyelle.rxpermissions2.RxPermissions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;



public class Activity_Main extends AppCompatActivity {
    private Context thisCon = null;
    private TextView txtTips = null;
    private String ConnectType = "";
    private UsbDevice device = null;
    private static final String ACTION_USB_PERMISSION = "com.HPRTSDKSample";
    private PendingIntent mPermissionIntent = null;
    private Handler handler;
    private ProgressDialog dialog;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private String mStatusStr = "";
    private static final int REQUEST_ENABLE_BT = 2;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        setTitle(BuildConfig.VERSION_NAME);
        try {
            initView();
            initUSB();
            enableBluetooth();
            createHandler();
        } catch (Exception e) {
        }

    }

    private void initView() {
        thisCon = this.getApplicationContext();
        txtTips = findViewById(R.id.txtTips);
    }

    private void createHandler() {
        handler = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 1) {
                    Toast.makeText(thisCon, "succeed", Toast.LENGTH_SHORT).show();
                    dialog.cancel();
                } else {
                    Toast.makeText(thisCon, "failure", Toast.LENGTH_SHORT).show();
                    txtTips.setText(thisCon.getString(R.string.activity_main_disconnected));
                    dialog.cancel();
                }
            }
        };
    }

    private void initUSB() {
        Intent intent = new Intent(ACTION_USB_PERMISSION);
        intent.setPackage(thisCon.getPackageName());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            mPermissionIntent = PendingIntent.getBroadcast(thisCon, 0, intent, FLAG_MUTABLE);
        } else {
            mPermissionIntent = PendingIntent.getBroadcast(thisCon, 0, intent, 0);
        }
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
        thisCon.registerReceiver(mUsbReceiver, filter);

        IntentFilter filterDisconnect = new IntentFilter();
        filterDisconnect.addAction(BluetoothDevice.ACTION_ACL_DISCONNECTED);
        filterDisconnect.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        registerReceiver(mReceiver, filterDisconnect);
    }


    //EnableBluetooth
    @SuppressLint("MissingPermission")
    private boolean enableBluetooth() {
        boolean bRet = false;
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mBluetoothAdapter != null) {
            if (mBluetoothAdapter.isEnabled())
                return true;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                RxPermissions rxPermissions = new RxPermissions(this);
                rxPermissions.request(Manifest.permission.BLUETOOTH_CONNECT).subscribe(aBoolean-> {
                    if (aBoolean) {
                        if (ActivityCompat.checkSelfPermission(Activity_Main.this, Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED) {
                            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                            startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
                            return;
                        }
                    }
                });
            } else {
                mBluetoothAdapter.enable();
            }
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!mBluetoothAdapter.isEnabled()) {
                bRet = true;
            }
        } else {
        }
        return bRet;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, final Intent data) {
        try {
            switch (resultCode) {
                case RESULT_CANCELED:
                    connectBT(data.getStringExtra("SelectedBDAddress"));
                case Constants.ACTIVITY_CONNECT_WIFI:
                    connectWifi(data);
                    return;
                case Constants.ACTIVITY_PRNFILE:
                    String pdfFilePath = data.getExtras().getString("FilePath");
                    File pdfFile = new File(pdfFilePath);
                    if (pdfFile == null) {
                        Toast.makeText(thisCon, "file error", Toast.LENGTH_SHORT).show();
                        return;
                    }
                    selectImageModel(pdfFile);
                    return;
                case RESULT_OK:
                    if (requestCode == Constants.ACTIVITY_PRNFILE) {
                        Uri uri = data.getData();
                        File file = Utility.uriToFileApiQ(uri, thisCon);
                        if (file == null) {
                            Toast.makeText(thisCon, "file error", Toast.LENGTH_SHORT).show();
                            return;
                        }
                        selectImageModel(file);
                        return;
                    }
                    return;
            }
        } catch (Exception e) {
        }
        super.onActivityResult(requestCode, resultCode, data);
    }


    private void connectWifi(Intent data) {
        String strIsConnected = data.getExtras().getString("is_connected");
        String printTAG = data.getExtras().getString("PRINT_TAG");
        if (strIsConnected.equals("NO")) {
            txtTips.setText(thisCon.getString(R.string.activity_main_connecterr));
        } else {
            txtTips.setText(printTAG+" "+thisCon.getString(R.string.activity_main_connected));
        }
    }

    private void selectImageModel(File file) {
        final String[] paperType = getResources().getStringArray(R.array.print_image_model);
        AlertDialog.Builder builder = new AlertDialog.Builder(Activity_Main.this);
        builder.setTitle(getResources().getString(R.string.activity_main_print_image_model))
                .setItems(paperType, (dialogInterface, i) -> {
                    switch (i) {
                        case 0:
                            printPDF(file, false, 0);
                            break;
                        case 1:
                            printPDF(file, false, 1);
                            break;
                        case 2:
                            printPDF(file, true, 0);
                            break;
                        case 3:
                            printPDF(file, true, 1);
                            break;
                        default:
                            break;
                    }
                }).show();
    }

    private void printPDF(File file, boolean model, int type) {
        dialog = new ProgressDialog(Activity_Main.this);
        dialog.setMessage("Printing.....");
        dialog.setProgress(100);
        dialog.show();
        new Thread() {
            @Override
            public void run() {
                super.run();
                try {
                    List<Bitmap> bitmaps = Utility.pdfToBitmap(thisCon, file, "1", 576);
                    if (bitmaps == null || bitmaps.size() == 0 || bitmaps.get(0) == null) {
                        handler.sendEmptyMessage(0);
                        return;
                    }
                    for (int i = 0; i < bitmaps.size(); i++) {
                        Bitmap bitmap = bitmaps.get(i);
                        for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                            PrinterTSPL printer = iterator.next();
                            printer.printAreaSize("" + (bitmap.getWidth() / 8), "" + (bitmap.getHeight() / 8));
                            printer.cls();
                            printer.printImage("0", "0", bitmap, true, model, type);
                            if (printer.print("1", "1") != -1) {
                                handler.sendEmptyMessage(1);
                            } else {
                                printerSendFail(iterator, printer,true);
                                handler.sendEmptyMessage(0);
                            }
                        }
                    }
                } catch (Exception e) {
                    handler.sendEmptyMessage(0);
                }
            }
        }.start();
    }

    private void connectBT(String selectedBDAddress) {
        if (TextUtils.isEmpty(selectedBDAddress))
            return;
        final ProgressDialog progressDialog = new ProgressDialog(Activity_Main.this);
        progressDialog.setMessage(getString(R.string.activity_devicelist_connect));
        progressDialog.show();
        new Thread() {
            @Override
            public void run() {
                super.run();
                try {
                    PrinterTSPL printer = PrinterHelper.connectBT(selectedBDAddress);
                    runOnUiThread(() -> {
                        if (printer != null){
                            PrinterUtils.addPrinter(printer);
                            txtTips.setText(printer.getPrinterTAG() + " " + thisCon.getString(R.string.activity_main_connected));
                        } else{
                            txtTips.setText(selectedBDAddress + "" + thisCon.getString(R.string.activity_main_connecterr));
                        }
                    });
                    progressDialog.dismiss();
                } catch (Exception e) {
                    progressDialog.dismiss();
                }
            }
        }.start();
    }

    @SuppressLint("NewApi")
    public void onClickConnect(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            if (view.getId() == R.id.btnBT) {
                openBTActivity();
            } else if (view.getId() == R.id.btnWIFI) {
                openWifiActivity();
            } else if (view.getId() == R.id.btnUSB) {
                openUSB();
            }
        } catch (Exception e) {
            Log.e("Activity_Main --> onClickConnect " + ConnectType + e.getMessage());
        }
    }

    private void openUSB() {
        ConnectType = "USB";
        //USB not need call "iniPort"
        UsbManager mUsbManager = (UsbManager) thisCon.getSystemService(Context.USB_SERVICE);
        HashMap<String, UsbDevice> deviceList = mUsbManager.getDeviceList();
        Iterator<UsbDevice> deviceIterator = deviceList.values().iterator();
        boolean HavePrinter = false;
        while (deviceIterator.hasNext()) {
            device = deviceIterator.next();
            int count = device.getInterfaceCount();
            for (int i = 0; i < count; i++) {
                UsbInterface intf = device.getInterface(i);
                if (intf.getInterfaceClass() == 7) {
                    HavePrinter = true;
                    mUsbManager.requestPermission(device, mPermissionIntent);
                }
            }
        }
        if (!HavePrinter)
            txtTips.setText(thisCon.getString(R.string.activity_main_connect_usb_printer));
    }

    private void openWifiActivity() {
        ConnectType = "WiFi";
        Intent serverIntent = new Intent(thisCon, Activity_Wifi.class);
        startActivityForResult(serverIntent, Constants.ACTIVITY_CONNECT_WIFI);
    }

    private void openBTActivity() {
        RxPermissions rxPermissions = new RxPermissions(this);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            rxPermissions.request(Manifest.permission.BLUETOOTH_ADMIN,
                    Manifest.permission.BLUETOOTH,
                    Manifest.permission.BLUETOOTH_CONNECT,
                    Manifest.permission.BLUETOOTH_SCAN,
                    Manifest.permission.ACCESS_FINE_LOCATION).subscribe(aBoolean-> {
                if (aBoolean) {
                    ConnectType = "Bluetooth";
                    Intent intent = new Intent(thisCon, BTActivity.class);
                    intent.putExtra("TAG", 0);
                    startActivityForResult(intent, 0);
                }
            });
        } else {
            rxPermissions.request(Manifest.permission.BLUETOOTH_ADMIN,
                    Manifest.permission.BLUETOOTH,
                    Manifest.permission.ACCESS_FINE_LOCATION).subscribe(aBoolean -> {
                if (aBoolean) {
                    ConnectType = "Bluetooth";
                    Intent intent = new Intent(thisCon, BTActivity.class);
                    intent.putExtra("TAG", 0);
                    startActivityForResult(intent, 0);
                }
            });
        }
    }

    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            try {
                String action = intent.getAction();
                if (ACTION_USB_PERMISSION.equals(action)) {
                    synchronized (this) {
                        device = intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
                        if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
                            PrinterTSPL printer = PrinterHelper.connectUSB(device);
                            if (printer == null) {
                                txtTips.setText(device.getDeviceName()+" "+thisCon.getString(R.string.activity_main_connecterr));
                                return;
                            } else{
                                PrinterUtils.addPrinter(printer);
                                txtTips.setText(printer.getPrinterTAG()+" "+thisCon.getString(R.string.activity_main_connected));
                            }
                        } else {
                            return;
                        }
                    }
                }
                if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action)) {
                    device = intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
                    if (device != null) {
                        int count = device.getInterfaceCount();
                        for (int i = 0; i < count; i++) {
                            UsbInterface intf = device.getInterface(i);
                            //Class ID 7代表打印机
                            if (intf.getInterfaceClass() == 7) {
                                for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                                    PrinterTSPL printer = iterator.next();
                                    if (printer.getPrinterTAG().equals(device.getDeviceName())){
                                        printer.portClose();
                                        printerSendFail(iterator, printer, false);
                                    }
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                Log.e("Activity_Main --> mUsbReceiver " + e.getMessage());
            }
        }
    };

    public void onClickClose(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            for (int i = 0; i < PrinterUtils.getPrinters().size(); i++) {
                PrinterTSPL printer = PrinterUtils.getPrinters().get(i);
                printer.portClose();
            }
            PrinterUtils.getPrinters().clear();
            this.txtTips.setText(R.string.activity_main_tips);
            return;
        } catch (Exception e) {
            Log.e("Activity_Main --> onClickClose " + e.getMessage());
        }
    }

    public void onClickDo(View view) {
        if (!CheckClick.isClickEvent()) return;

        if (PrinterUtils.getPrinters().size() == 0) {
            Toast.makeText(thisCon, thisCon.getText(R.string.activity_main_tips), Toast.LENGTH_SHORT).show();
            return;
        }
        if (view.getId() == R.id.btnSampleReceipt) {
            printSampleReceipt();
        } else if (view.getId() == R.id.btn1DBarcodes) {
            Intent myIntent = new Intent(this, Activity_1DBarcodes.class);
            startActivityFromChild(this, myIntent, 0);
        } else if (view.getId() == R.id.btnTextFormat) {
            Intent myIntent = new Intent(this, Activity_TextFormat.class);
            startActivityFromChild(this, myIntent, 0);
        } else if (view.getId() == R.id.btnPrintImageFile) {
            openImageFile();
        } else if (view.getId() == R.id.btnPrintPDF417) {
            printPDF417();
        } else if (view.getId() == R.id.btnQRCode) {
            Intent myIntent = new Intent(this, Activity_QRCode.class);
            startActivityFromChild(this, myIntent, 0);
        } else if (view.getId() == R.id.btnPrintTestPage) {
            printSelf();
        } else if (view.getId() == R.id.btnPrintStatus) {
            getPrintStatus();
        } else if (view.getId() == R.id.btnPrintBlock) {
            printBlock();
        } else if (view.getId() == R.id.btn_print_pdf) {
            openPDF();
        } else if (view.getId() == R.id.btn_set_black_position) {
            setBlackPosition();
        } else if (view.getId() == R.id.btnGetSN){
            getSN();
        }
    }

    private void getSN() {
        executorService.execute(() -> {
            try {
                for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                    PrinterTSPL printer = iterator.next();
                    String sn = printer.getPrinterSN();
                    runOnUiThread(() -> Toast.makeText(thisCon, sn, Toast.LENGTH_SHORT).show());
                }
            } catch (Exception e) {
            }
        });
    }

    private void setBlackPosition() {
        AlertDialog.Builder builder = new AlertDialog.Builder(Activity_Main.this);
        builder.setIcon(R.drawable.logo2);
        final String[] cities = getResources().getStringArray(R.array.activity_main_black);
        builder.setItems(cities, (dialog, which) -> {
            for (int i = 0; i < PrinterUtils.getPrinters().size(); i++) {
                PrinterTSPL printer = PrinterUtils.getPrinters().get(i);
                printer.setBlackPosition(which + 1);
            }
        });
        builder.show();
    }

    private void openPDF() {
        String[] permissions;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            permissions = new String[]{Manifest.permission.READ_MEDIA_IMAGES, Manifest.permission.READ_MEDIA_AUDIO, Manifest.permission.READ_MEDIA_VIDEO};
        } else {
            permissions = new String[]{Manifest.permission.READ_EXTERNAL_STORAGE};
        }
        RxPermissions rxPermissions = new RxPermissions(this);
        rxPermissions.request(permissions).subscribe(aBoolean -> {
            if (aBoolean) {
                printPDF();
            }
        });
    }

    private void printSelf() {
        try {
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                int result = printer.selfTest();
                if (result == -1){
                    printerSendFail(iterator, printer, true);
                }
            }
        } catch (Exception e) {
            Log.e("Activity_Main --> onClickWIFI " + e.getMessage());
        }
    }

    private void openImageFile() {
        String[] permissions;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            permissions = new String[]{Manifest.permission.READ_MEDIA_IMAGES, Manifest.permission.READ_MEDIA_AUDIO, Manifest.permission.READ_MEDIA_VIDEO};
        } else {
            permissions = new String[]{Manifest.permission.READ_EXTERNAL_STORAGE};
        }
        RxPermissions rxPermissions = new RxPermissions(this);
        rxPermissions.request(permissions).subscribe(aBoolean -> {
            if (aBoolean) {
                PictureSelector.create(Activity_Main.this)
                        .openGallery(SelectMimeType.ofImage())
                        .setImageEngine(GlideEngine.createGlideEngine())
                        .setMaxSelectNum(1)
                        .forResult(new OnResultCallbackListener<LocalMedia>() {
                            @Override
                            public void onResult(ArrayList<LocalMedia> result) {
                                setPrintDialog(result);
                            }

                            @Override
                            public void onCancel() {

                            }
                        });
            }
        });
    }

    private void setPrintDialog(ArrayList<LocalMedia> result) {
        String path = result.get(0).getPath();
        if (path.contains("content://")) {
            Uri uri = Uri.parse(path);
            path = com.sdk.tspl.demo.FileUtils.getFilePathByUri_BELOWAPI11(uri, this);
        }
        final Bitmap bmp = BitmapFactory.decodeFile(path);
        if (bmp == null) {
            Toast.makeText(thisCon, "Image error", Toast.LENGTH_SHORT).show();
            return;
        }
        ProgressDialog dialog = new ProgressDialog(Activity_Main.this);
        dialog.setMessage("Printing.....");
        dialog.setProgress(100);
        dialog.show();
        new Thread() {
            @Override
            public void run() {
                super.run();
                try {
                    int height = bmp.getHeight() / 8;
                    for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                        PrinterTSPL printer = iterator.next();
                        if (printer.printAreaSize("100", "" + height) == -1){
                            printerSendFail(iterator, printer, true);
                            break;
                        }
                        printer.cls();
                        printer.printImage("100", "0", bmp, true, false, 0);
                        printer.print("1", "1");
                    }
                    dialog.dismiss();
                } catch (Exception e) {
                    Log.e("print image error ->"+e.getMessage());
                    dialog.dismiss();
                }
            }
        }.start();
    }

    private void printPDF417() {
        try {
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                if(printer.printAreaSize("100", "100") == -1){
                    printerSendFail(iterator, printer, true);
                    break;
                }
                printer.cls();
                ArrayList<String> option = new ArrayList<>();
                option.add("P1");
                option.add("E4");
                option.add("M1");
                option.add("U100,500,10");
                option.add("W6");
                option.add("H6");
                option.add("R60");
                option.add("C4");
                option.add("T1");
                option.add("L297");
                String data = "Data" +
                        "compression method: P1" +
                        "Error correction level: E4" +
                        "Center pattern in barcode area: M1" +
                        "Human Readable: Yes: U100,500,10" +
                        "Module Width 6 dots: W6" +
                        "Bar Height 6 dots: H6" +
                        "Maximum Number of Rows: 60 Rows: R60" +
                        "Maximum number of columns: 4 Cols: C4" +
                        "Truncation:1: T1" +
                        "Expression length:297: L297";
                printer.printPDF417(50, 50, 900, 600, 0, option, data);
                printer.print("1", "1");
            }
        } catch (Exception e) {
        }
    }

    private void printPDF() {
        Intent myIntent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
        myIntent.addCategory(Intent.CATEGORY_OPENABLE);
        myIntent.setType("*/*");
        try {
            startActivityForResult(myIntent, Constants.ACTIVITY_PRNFILE);
        } catch (Exception e) {
            Log.e("printPDF error ->"+e.getMessage());
        }
    }

    private void printBlock() {
        try {
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                if(printer.printAreaSize("100", "100") == -1){
                    printerSendFail(iterator, printer, true);
                    break;
                }
                printer.cls();
                printer.printBlock(0, 0, 200, 100, 0, 0, 2, 2, 16, 2, "TestTestTestTest");
                printer.print("1", "1");
            }
        } catch (Exception e) {
        }
    }

    private void getPrintStatus() {
        executorService.execute(() -> {
            try {
                for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                    PrinterTSPL printer = iterator.next();
                    int printerStatus = printer.getPrinterStatus();
                    switch (printerStatus) {
                        case Constants.STATUS_DISCONNECT:
                            mStatusStr = getString(R.string.status_disconnect);
                            break;
                        case Constants.STATUS_TIMEOUT:
                            mStatusStr = getString(R.string.status_timeout);
                            break;
                        case Constants.STATUS_OK:
                            mStatusStr = getString(R.string.status_ok);
                            break;
                        case Constants.STATUS_COVER_OPENED:
                            mStatusStr = getString(R.string.status_cover_opened);
                            break;
                        case Constants.STATUS_NOPAPER:
                            mStatusStr = getString(R.string.status_nopaper);
                            break;
                        case Constants.STATUS_OVER_HEATING:
                            mStatusStr = getString(R.string.status_over_heating);
                            break;
                        case Constants.STATUS_PRINTING:
                            mStatusStr = getString(R.string.status_printing);
                            break;
                        default:
                            break;
                    }
                    runOnUiThread(() -> Toast.makeText(thisCon, mStatusStr, Toast.LENGTH_SHORT).show());
                }
            } catch (Exception e) {
            }
        });
    }


    private void printSampleReceipt() {
        executorService.submit(() -> {
            try {
                for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                    PrinterTSPL printer = iterator.next();
                    if (printer.printAreaSize("100", "100") == -1) {
                        printerSendFail(iterator, printer, true);
                        break;
                    }
                    printer.cls();
                    String[] ReceiptLines = getResources().getStringArray(R.array.activity_main_sample_2inch_receipt);
                    for (int i = 0; i < ReceiptLines.length; i++) {
                        printer.printText("50", "" + (i * 30), "9", "0", 2, ReceiptLines[i]);
                    }
                    printer.printQRCode("10", "640", "M", "5", "M1", "0", "123ABC");
                    printer.printQRCode("200", "640", "M", "5", "M1", "0", "123ABC");
                    printer.print("1", "1");
                }

            } catch (Exception e) {
                Log.e((new StringBuilder("Activity_Main --> PrintSampleReceipt ")).append(e.getMessage()).toString());
            }
        });

    }

    public final BroadcastReceiver mReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (BluetoothDevice.ACTION_ACL_DISCONNECTED.equals(action)) {
                BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                if (device != null) {
                    String macAddress = device.getAddress();
                    for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                        PrinterTSPL printer = iterator.next();
                        if (printer.getPrinterTAG().equals(macAddress)){
                            printerSendFail(iterator, printer, false);
                        }
                    }
                }
            }
            if (ConnectivityManager.CONNECTIVITY_ACTION.equals(action)) {
                NetworkInfo info = intent.getParcelableExtra(ConnectivityManager.EXTRA_NETWORK_INFO);
                if (info != null) {
                    if (!(NetworkInfo.State.CONNECTED == info.getState() && info.isAvailable())) {
                    }
                }
            }
        }
    };

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                printer.portClose();
            }
            PrinterUtils.getPrinters().clear();
            unregisterReceiver(mUsbReceiver);
            unregisterReceiver(mReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printerSendFail(Iterator<PrinterTSPL> iterator, PrinterTSPL printer, boolean isSend) {
        runOnUiThread(() -> {
            txtTips.setText(printer.getPrinterTAG() + " " + getResources().getString(R.string.activity_main_disconnected));
        });
        if (isSend){
            ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        }
        iterator.remove();
    }
}
