package com.sdk.tspl.demo;


import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.prt.tspl.log.Log;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.luck.picture.lib.utils.ToastUtils;
import com.prt.tspl.printer.PrinterTSPL;

import java.util.Iterator;


public class Activity_QRCode extends AppCompatActivity {
    private Context thisCon = null;
    private Spinner spnQRCodeModel = null;
    private Spinner spnQRCodeLevel = null;
    private EditText txtQRCodeData = null;
    private EditText txtQRCodeX = null;
    private EditText txtQRCodeY = null;
    private int mQRCodeRotation = 0;
    private int mQRCodeSize = 3;
    private String mQRCodeModel = "A";
    private String mQRCodeLevel = "L";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_qrcode);
        thisCon = this.getApplicationContext();

        txtQRCodeData = this.findViewById(R.id.txtQRCodeData);
        txtQRCodeX = this.findViewById(R.id.txtqrcode_x);
        txtQRCodeY = this.findViewById(R.id.txtqrcode_y);


        String[] sList;
        Spinner spnQRCodeSize = findViewById(R.id.spnQRCodeSize);
        sList = "1,2,3,4,5,6,7,8,9,10".split(",");
        ArrayAdapter<String> arrQRCodeSize = new ArrayAdapter<>(Activity_QRCode.this, android.R.layout.simple_spinner_item, sList);
        arrQRCodeSize.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnQRCodeSize.setAdapter(arrQRCodeSize);
        spnQRCodeSize.setOnItemSelectedListener(new OnItemSelectedQRCodeSize());

        spnQRCodeModel = findViewById(R.id.spnQRCodeModel);
        sList = "A".split(",");
        ArrayAdapter<String> arrQRCodeModel = new ArrayAdapter<>(Activity_QRCode.this, android.R.layout.simple_spinner_item, sList);
        arrQRCodeModel.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnQRCodeModel.setAdapter(arrQRCodeModel);
        spnQRCodeModel.setOnItemSelectedListener(new OnItemSelectedQRCodeModel());

        spnQRCodeLevel = findViewById(R.id.spnQRCodeLevel);
        sList = "L,M,Q,H".split(",");
        ArrayAdapter<String> arrQRCodeLevel = new ArrayAdapter<>(Activity_QRCode.this, android.R.layout.simple_spinner_item, sList);
        arrQRCodeLevel.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnQRCodeLevel.setAdapter(arrQRCodeLevel);
        spnQRCodeLevel.setOnItemSelectedListener(new OnItemSelectedQRCodeLevel());

        Spinner spnQECodeRotation = findViewById(R.id.spnqrcode_rotation);
        ArrayAdapter arrQRCodeRotation = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_hri_rotation, android.R.layout.simple_spinner_item);
        arrQRCodeRotation.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnQECodeRotation.setAdapter(arrQRCodeRotation);
        spnQECodeRotation.setOnItemSelectedListener(new OnItemSelectedQRCodeRotation());
    }

    private class OnItemSelectedQRCodeRotation implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mQRCodeRotation = arg2 * 90;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedQRCodeSize implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mQRCodeSize = arg2 + 1;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedQRCodeModel implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mQRCodeModel = spnQRCodeModel.getSelectedItem().toString();
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedQRCodeLevel implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            mQRCodeLevel = spnQRCodeLevel.getSelectedItem().toString();
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    public void onClickPrint(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            String text = txtQRCodeData.getText().toString().trim();
            if (text.length() == 0) {
                Toast.makeText(thisCon, getString(R.string.activity_qrcode_no_data), Toast.LENGTH_SHORT).show();
                return;
            }
            text = text.replace("\n", "\r\n");
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                if (printer.printAreaSize("100", "80") == -1) {
                    printerSendFail(iterator, printer);
                    return;
                }
                printer.cls();
                printer.printQRCode(txtQRCodeX.getText().toString(), txtQRCodeY.getText().toString(), mQRCodeLevel, "" + mQRCodeSize, mQRCodeModel, "" + mQRCodeRotation, text);
                printer.print("1", "1");
            }
        } catch (Exception e) {
            Log.e("Activity_QRCode --> onClickPrint " + e.getMessage());
        }
    }
    private void printerSendFail(Iterator<PrinterTSPL> iterator, PrinterTSPL printer) {
        ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        iterator.remove();
    }
}
