package com.sdk.tspl.demo;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;

import com.luck.picture.lib.utils.ToastUtils;
import com.prt.tspl.log.Log;

import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.blankj.utilcode.util.LogUtils;
import com.prt.tspl.PrinterHelper;
import com.prt.tspl.printer.PrinterTSPL;

import java.util.Iterator;


public class Activity_TextFormat extends AppCompatActivity {
    private Context thisCon = null;
    private EditText txtText = null;
    private EditText txtFormatX = null;
    private EditText txtFormatY = null;
    private String formatFont = "0";
    private int xMultiplication = 1;
    private int qrCodeRotation = 0;
    private int bold = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_text_format);
        thisCon = this.getApplicationContext();

        txtText = findViewById(R.id.txtText);
        txtFormatX = findViewById(R.id.txtformat_x);
        txtFormatY = findViewById(R.id.txtformat_y);
        Spinner spnFormatFont = findViewById(R.id.spnformat_font);
        Spinner spnFormatCodepage = findViewById(R.id.spnformat_codepage);

        String[] sList = "0,1,2,3,4,5,6,7,8,9".split(",");
        ArrayAdapter<String> arrFormatFont = new ArrayAdapter<>(Activity_TextFormat.this, android.R.layout.simple_spinner_item, sList);
        arrFormatFont.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnFormatFont.setAdapter(arrFormatFont);
        spnFormatFont.setOnItemSelectedListener(new OnItemSelectedFormatFont());

        String[] mList = getResources().getStringArray(R.array.codepage_list);
        ArrayAdapter arrFormatCodepage = new ArrayAdapter<>(Activity_TextFormat.this, android.R.layout.simple_spinner_item, mList);
        arrFormatCodepage.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnFormatCodepage.setAdapter(arrFormatCodepage);
        spnFormatCodepage.setOnItemSelectedListener(new OnItemSelectedCodePage());

        Spinner spnFormatRotation = findViewById(R.id.spnformat_rotation);
        ArrayAdapter<CharSequence> arrFormatRotation = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_hri_rotation, android.R.layout.simple_spinner_item);
        arrFormatRotation.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnFormatRotation.setAdapter(arrFormatRotation);
        spnFormatRotation.setOnItemSelectedListener(new OnItemSelectedFormatRotation());

        sList = "1,2,3,4,5,6,7".split(",");
        Spinner spnFormatXMultiplication = findViewById(R.id.spnformat_x_multiplication);
        ArrayAdapter<String> arrFormatXMultiplication = new ArrayAdapter<>(Activity_TextFormat.this, android.R.layout.simple_spinner_item, sList);
        arrFormatXMultiplication.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnFormatXMultiplication.setAdapter(arrFormatXMultiplication);
        spnFormatXMultiplication.setOnItemSelectedListener(new OnItemSelectedFormatXMultiplication());

        Spinner spnFormatYMultiplication = findViewById(R.id.spnformat_y_multiplication);
        ArrayAdapter<String> arrFormatYMultiplication = new ArrayAdapter<>(Activity_TextFormat.this, android.R.layout.simple_spinner_item, getResources().getStringArray(R.array.activity_text_bold));
        arrFormatYMultiplication.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnFormatYMultiplication.setAdapter(arrFormatYMultiplication);
        spnFormatYMultiplication.setOnItemSelectedListener(new OnItemSelectedFormatYMultiplication());
    }

    private class OnItemSelectedCodePage implements OnItemSelectedListener {

        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {

        }
    }

    private class OnItemSelectedFormatRotation implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            qrCodeRotation = arg2 * 90;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
            // TODO Auto-generated method stub
        }
    }

    private class OnItemSelectedFormatFont implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            switch (arg2) {
                case 0:
                    formatFont = "0";
                    break;
                case 1:
                    formatFont = "1";
                    break;
                case 2:
                    formatFont = "2";
                    break;
                case 3:
                    formatFont = "3";
                    break;
                case 4:
                    formatFont = "4";
                    break;
                case 5:
                    formatFont = "5";
                    break;
                case 6:
                    formatFont = "6";
                    break;
                case 7:
                    formatFont = "7";
                    break;
                case 8:
                    formatFont = "8";
                    break;
                case 9:
                    formatFont = "9";
                    break;

                default:
                    break;
            }

        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
            // TODO Auto-generated method stub
        }
    }

    private class OnItemSelectedFormatXMultiplication implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            xMultiplication = arg2 + 1;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedFormatYMultiplication implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            bold = arg2;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
            // TODO Auto-generated method stub
        }
    }

    public void onClickPrint(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            String sText = txtText.getText().toString().trim();
            if (sText.length() == 0) {
                Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_no_data), Toast.LENGTH_SHORT).show();
                return;
            }
            sText = sText.replace("\n", "\r\n");
            for (Iterator<PrinterTSPL> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                PrinterTSPL printer = iterator.next();
                if (printer.printAreaSize("100", "30") == -1) {
                    printerSendFail(iterator, printer);
                    return;
                }
                printer.cls();
                if (bold != 0) {
                    printer.bold(bold);
                }
                printer.printText(txtFormatX.getText().toString(), txtFormatY.getText().toString(), formatFont, "" + qrCodeRotation, xMultiplication, sText);
                if (bold != 0) {
                    printer.bold(0);
                }
                printer.print("1", "1");
            }
        } catch (Exception e) {
            Log.e("Activity_TextFormat --> onClickPrint " + e.getMessage());
        }
    }

    private void printerSendFail(Iterator<PrinterTSPL> iterator, PrinterTSPL printer) {
        ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        iterator.remove();
    }
}
