package com.sdk.tspl.demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.prt.tspl.constant.Constants;
import com.prt.tspl.log.Log;

import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.prt.tspl.PrinterHelper;
import com.prt.tspl.printer.PrinterTSPL;
import com.prt.tspl.printer.PublicFunction;


public class Activity_Wifi extends Activity {
    private Context thisCon = null;
    private EditText edtIP = null;
    private EditText edtPort = null;
    private TextView txtTips = null;
    private PublicFunction publicFunction;


    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_wifi);

        thisCon = this.getApplicationContext();
        publicFunction = new PublicFunction(thisCon);
        edtIP = findViewById(R.id.txtIPAddress);
        edtPort = findViewById(R.id.txtWifiPort);
        txtTips = findViewById(R.id.txtTips);
        String ip = publicFunction.readSharedPreferencesData("IP");
        if (!ip.isEmpty()){
            edtIP.setText(ip);
        }
    }

    public void onClickConnect(View view) {
        if (!CheckClick.isClickEvent()) return;
        try {
            String strIP = edtIP.getText().toString().trim();
            String strPort = edtPort.getText().toString().trim();
            if (strIP.length() == 0) {
                Toast.makeText(thisCon, R.string.activity_wifi_noIP, Toast.LENGTH_SHORT).show();
                return;
            }
            PrinterTSPL printer = PrinterHelper.connectWifi(strIP);
            if (printer == null) {
                txtTips.setText(thisCon.getString(R.string.activity_main_connecterr));
            } else {
                publicFunction.writeSharedPreferencesData("IP",strIP);
                PrinterUtils.addPrinter(printer);
                Intent intent = new Intent();
                intent.putExtra("is_connected", "OK");
                intent.putExtra("PRINT_TAG", printer.getPrinterTAG());
                setResult(Constants.ACTIVITY_CONNECT_WIFI, intent);
                finish();
            }
        } catch (Exception e) {
            Log.e("Activity_Wifi --> onClickConnect " + e.getMessage());
        }
    }

    public void onClickCancel(View view) {
        if (!CheckClick.isClickEvent()) return;
        try {
            this.finish();
        } catch (Exception e) {
            Log.e("Activity_Wifi --> onClickCancel " + e.getMessage());
        }
    }
}
