package com.sdk.tspl.demo;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.RelativeLayout;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;

import java.util.ArrayList;
import java.util.List;


public class BTActivity extends AppCompatActivity {

    private Context mContext;
    public BluetoothAdapter myBluetoothAdapter;
    private Intent intent;
    private BaseQuickAdapter<BluetoothDevice, BaseViewHolder> baseQuickAdapter;
    private List<BluetoothDevice> list;
    private int tag;
    private Bluetooth bluetooth;
    private ProgressDialog progressDialog;
    private RecyclerView recyHistory;
    private SwipeRefreshLayout swipeRefresh;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_bt);
        mContext = getApplicationContext();
        recyHistory = findViewById(R.id.recy_history);
        swipeRefresh = findViewById(R.id.swipe_refresh);
        initData();
    }

    private void initData() {
        intent = getIntent();
        tag = intent.getIntExtra("TAG", RESULT_CANCELED);
        ListBluetoothDevice();
    }
    @SuppressLint("MissingPermission")
    public void ListBluetoothDevice() {
        if ((myBluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) == null) {
            Toast.makeText(this, "没有找到蓝牙适配器", Toast.LENGTH_LONG).show();
            return;
        }

        if (!myBluetoothAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableBtIntent, 2);
        }
        list = new ArrayList<>();
        baseQuickAdapter = new BaseQuickAdapter<BluetoothDevice, BaseViewHolder>(android.R.layout.simple_list_item_2, list) {

            @Override
            protected void convert(@NonNull BaseViewHolder helper, BluetoothDevice item) {
                if (item!=null){
                    if (item.getName()!=null)
                        helper.setText(android.R.id.text1, item.getName().isEmpty()?"Null":item.getName());
                    helper.setText(android.R.id.text2, item.getAddress());
                }
            }
        };
        recyHistory.setLayoutManager(new LinearLayoutManager(mContext));
        recyHistory.addItemDecoration(new DividerItemDecoration(mContext, DividerItemDecoration.VERTICAL));
        recyHistory.setAdapter(baseQuickAdapter);
        bluetooth = Bluetooth.getBluetooth(this);
        initBT();
        baseQuickAdapter.setOnItemClickListener((adapter, view, position) -> {
            Bluetooth.setOnBondState(list.get(position), () -> {
                if (progressDialog!=null&&progressDialog.isShowing())
                    progressDialog.dismiss();
                Intent intent = new Intent();
                intent.putExtra("SelectedBDAddress", list.get(position).getAddress());
                setResult(tag, intent);
                finish();
            });
            if (list.get(position).getBondState()==BluetoothDevice.BOND_BONDED){
                Intent intent = new Intent();
                intent.putExtra("SelectedBDAddress", list.get(position).getAddress());
                setResult(tag, intent);
                finish();
            }else{
                progressDialog = new ProgressDialog(BTActivity.this);
                progressDialog.setMessage(getString(R.string.activity_devicelist_connect));
                progressDialog.show();
                new Thread(() -> list.get(position).createBond()).start();
            }
        });
        swipeRefresh.setColorSchemeResources(R.color.colorPrimary);
        swipeRefresh.setOnRefreshListener(() -> {
            initBT();
            if (swipeRefresh.isRefreshing())
                swipeRefresh.setRefreshing(false);
        });
    }
    private void initBT() {
        list.clear();
        baseQuickAdapter.notifyDataSetChanged();
        bluetooth.doDiscovery();
        bluetooth.getData(bluetoothDevice -> {
            for (BluetoothDevice printBT : list) {
                if (bluetoothDevice.getAddress().equals(printBT.getAddress())) {
                    return;
                }
            }
            list.add(bluetoothDevice);
            baseQuickAdapter.notifyDataSetChanged();
        });
    }
    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (bluetooth!=null)
            bluetooth.disReceiver();
    }
}
