#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>

typedef int (*pPrinterCreator)(void** handle,const char* );

typedef int (*pPrinterDestroy)(void* handle);

typedef int (*pPrinterCreatorS)(char*);

typedef int (*pPortOpen)(void* handle,const char* );

typedef int (*pFormatError)(int errorNO,int ,unsigned char*,int,int);

typedef int (*pPortClose)(void* handle);

typedef int (*pTSPL_SelfTest)(void* handle);

typedef int (*pTSPL_TextCompatible)(void* handle,int,int,int,int,int,int,const char*text);

typedef int (*pTSPL_Print)(void* handle,int,int);

typedef int(*pDriverPortOpen)(void*, const char*);

typedef int(*pDirectIO)(void* handle, unsigned char writedata[], unsigned int writenum, unsigned char readdata[], unsigned int readnum, unsigned int* preadednum);

typedef int(*pTSPL_BitMap)(void*, int, int, int, const char*);
typedef int(*pTSPL_Setup)(void*, int, int, int, int, int, int, int);
typedef int(*pTSPL_ClearBuffer)(void*);
typedef int(*pTSPL_Box)(void*, int, int, int, int, int);
typedef int(*pTSPL_BarCode)(void*, int, int, int, int, int, int, int, int, const char*);
typedef int(*pTSPL_QrCode)(void*, int, int, int, int, int, int, int, int, const char*);
typedef int(*pTSPL_Dmatrix)(void*, int, int, int, int, int, int, int, const char*);
typedef int(*pTSPL_Text)(void*, int, int, int, int, int, int, int, const char*);
typedef int(*pTSPL_FormFeed)(void*);
typedef int(*pTSPL_SetTear)(void*, int);
typedef int(*pTSPL_SetRibbon)(void*, int);
typedef int(*pTSPL_Offset)(void*, int);
typedef int(*pTSPL_Direction)(void*, int);
			 
			 
typedef int(*pTSPL_Feed)(void*, int);
typedef int(*pTSPL_Home)(void*);
typedef int(*pTSPL_Learn)(void*);
typedef int(*pTSPL_GetDllVersion)(void*);
typedef int(*pTSPL_GetSN)(void*, char*);
typedef int(*pTSPL_GetPrinterStatus)(void*, int*);
typedef int(*pTSPL_SetCodePag)(void*, char*);
			 
typedef int(*pTSPL_Reverse)(void*, int, int, int, int);
typedef int(*pTSPL_GapDetect)(void*, int, int);
typedef int(*pTSPL_Cut)(void*, int);

pFormatError                                  DemFormatError;
pPrinterCreator                               DemPrinterCreator;
pPrinterCreatorS                              DemPrinterCreatorS;
pPrinterDestroy                               DemPrinterDestroy;
pPortOpen                                     DemPortOpen;
pDriverPortOpen                               DemDriverPortOpen;
pPortClose                                    DemPortClose;
pDirectIO                                     DemDirectIO;

pTSPL_SelfTest                                DemSelfTest;
pTSPL_BitMap                                  DemBitMap;
pTSPL_Setup                                   DemSetup;
pTSPL_ClearBuffer                             DemClearBuffer;
pTSPL_Box                                     DemBox;
pTSPL_BarCode                                 DemBarCode;
pTSPL_QrCode                                  DemQrCode;
pTSPL_Dmatrix                                 DemDmatrix;
pTSPL_Text                                    DemText;
pTSPL_Print                                   DemPrint;
pTSPL_FormFeed                                DemFormFeed;
pTSPL_SetTear                                 DemSetTear;
pTSPL_SetRibbon                               DemSetRibbon;
pTSPL_Offset                                  DemOffset;
pTSPL_Direction                               DemDirection;
pTSPL_Feed                                    DemFeed;
pTSPL_Home                                    DemHome;
pTSPL_Learn                                   DemLearn;
pTSPL_GetSN                                   DemGetSN;
pTSPL_GetPrinterStatus                        DemStatus;
pTSPL_SetCodePag                              DemCodePag;
pTSPL_Reverse                                 DemReverse;
pTSPL_GapDetect                               DemGapDetect;
pTSPL_Cut                                     DemCut;
pTSPL_TextCompatible						  DemTextCompatible;

void Test_tspl()
{	

	void *phandle = NULL;
 	int status = 0; 
	int result = 0;
	char error_msg[1024] = {0};
	void* handle = dlopen("./libtspl_sdk.so",RTLD_LAZY);
	if(!handle)
	{
		printf("Failed to load shared library.\r\n");
		return; 	
	}
	else
	{
		printf("Load successed.\r\n");
	}

	DemPrinterCreator = (pPrinterCreator)dlsym(handle,"PrinterCreator");
	DemPrinterDestroy = (pPrinterDestroy)dlsym(handle,"PrinterDestroy");
	DemPortOpen = (pPortOpen)dlsym(handle,"PortOpen");
	DemPortClose = (pPortClose)dlsym(handle,"PortClose");
	DemFormatError = (pFormatError)dlsym(handle, "FormatError");
	DemSelfTest = (pTSPL_SelfTest)dlsym(handle,"TSPL_SelfTest");

	DemPrint = (pTSPL_Print)dlsym(handle,"TSPL_Print");


	DemPrinterCreatorS = (pPrinterCreatorS)dlsym(handle, "PrinterCreatorS");
	DemDriverPortOpen = (pDriverPortOpen)dlsym(handle, "DriverPortOpen");
	DemDirectIO = (pDirectIO)dlsym(handle, "DirectIO");

	DemSelfTest = (pTSPL_SelfTest)dlsym(handle, "TSPL_SelfTest");
	DemBitMap = (pTSPL_BitMap)dlsym(handle, "TSPL_BitMap");
	DemSetup = (pTSPL_Setup)dlsym(handle, "TSPL_Setup");
	DemClearBuffer = (pTSPL_ClearBuffer)dlsym(handle, "TSPL_ClearBuffer");
	DemBox = (pTSPL_Box)dlsym(handle, "TSPL_Box");
	DemBarCode = (pTSPL_BarCode)dlsym(handle, "TSPL_BarCode");
	DemQrCode = (pTSPL_QrCode)dlsym(handle, "TSPL_QrCode");
	DemDmatrix = (pTSPL_Dmatrix)dlsym(handle, "TSPL_Dmatrix");
	DemText = (pTSPL_Text)dlsym(handle, "TSPL_Text");
	DemFormFeed = (pTSPL_FormFeed)dlsym(handle, "TSPL_FormFeed");
	DemSetTear = (pTSPL_SetTear)dlsym(handle, "TSPL_SetTear");
	DemSetRibbon = (pTSPL_SetRibbon)dlsym(handle, "TSPL_SetRibbon");
	DemOffset = (pTSPL_Offset)dlsym(handle, "TSPL_Offset");
	DemDirection = (pTSPL_Direction)dlsym(handle, "TSPL_Direction");

	DemFeed = (pTSPL_Feed)dlsym(handle, "TSPL_Feed");
	DemHome = (pTSPL_Home)dlsym(handle, "TSPL_Home");
	DemLearn = (pTSPL_Learn)dlsym(handle, "TSPL_Learn");

	DemGetSN = (pTSPL_GetSN)dlsym(handle, "TSPL_GetSN");
	DemStatus = (pTSPL_GetPrinterStatus)dlsym(handle, "TSPL_GetPrinterStatus");
	DemCodePag = (pTSPL_SetCodePag)dlsym(handle, "TSPL_SetCodePage");
	DemReverse = (pTSPL_Reverse)dlsym(handle, "TSPL_Reverse");
	DemGapDetect = (pTSPL_GapDetect)dlsym(handle, "TSPL_GapDetect");
	DemCut = (pTSPL_Cut)dlsym(handle, "TSPL_Cut");
	DemTextCompatible = (pTSPL_TextCompatible)dlsym(handle, "TSPL_TextCompatible");



	result = DemPrinterCreator(&phandle, "J70");
	//result = DemPrinterCreator(&phandle, "N43BT");
	if (0 != result)
	{
		DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
		printf("Creation fail:%s\n", error_msg);
       	  return;
  	}
	else
	{
		printf("Creation successed\r\n");
	}

	result = DemPortOpen(phandle, "USB,iT4E,vid=0x2aaf,pid=0x4010");
	//result = PortOpen(phandle, "COM,ttyUSB0,BAUDRATE=115200");

	if (0 != result)
	{
		DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
		printf("Open fail:%s\n", error_msg);
		return;
  	}
	else
	{
		printf("Open successed\r\n");
	}

	//printf("PortOpen result= %d\r\n",result);
	
	if (0 != result)
	{
		DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
	  	printf("%s\n", error_msg);
	}
	else
	{
			//result = DemSelfTest(phandle);
			int s = -100;
			DemStatus(phandle, &s);
			DemClearBuffer(phandle);
			DemSetup(phandle, 80, 150, 2, 6, 1, 1, 0);
			DemCut(phandle,1);
			//CODE128
			result = DemBarCode(phandle, 8, 0, 0, 50, 1, 0, 2, 2, "128");

			//CODE93
			result = DemBarCode(phandle, 8, 80, 8, 50, 1, 0, 2, 2, "01234567890238");

			//EAN13
			result = DemBarCode(phandle, 8, 160, 9, 50, 1, 0, 2, 2, "012345678902");

			//UPCA
			result = DemBarCode(phandle, 8, 240, 17, 50, 1, 0, 2, 2, "01234567811");

			//QRCODE
			result = DemQrCode(phandle, 8, 330, 3, 3, 0, 0, 0, 7, "\"1000000001\"");
			result = DemQrCode(phandle, 120, 330, 3, 3, 0, 0, 0, 7, "\"11111111\"");

			//ӡλֱ
			result = DemBox(phandle, 200, 150, 300, 200, 3);

			//ӡͼ·Ϊͼ·
			result = DemBitMap(phandle, 350, 350, 0, "/home/wj/Desktop/11.jpg");

			result = DemTextCompatible(phandle,200,200,9,0,5,5,"PRINTER TEXT");

			//ӡԼҳ
			//result = DemSelfTest(phandle);

			result = DemPrint(phandle, 1, 1); 

			DemPortClose(phandle);
			DemPrinterDestroy(phandle);
	}
	if(!result)
	{
		printf("ZPLTest success ");	
	}
	else
	{       
		printf("ZPLTest fail %d",result);
		DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
	  	printf("%s\n", error_msg);
	}
	
}


int main()
{
    Test_tspl();
    return 0;
}
