unit PrinterLib;

interface

function DemPrinterCreator(model: ansistring): Boolean;
function DemPortOpen(portSetting: ansistring): Integer;
function DemPortClose(): Integer;
function DemDerectIO(writedata: PByte; writeNum: Integer;
  readdata: PByte; readNum: Integer; var preadNum: Integer): Integer;

function DemSelftest(): Integer;
function DemFormfeed(): Integer;
function DemSetup(label_width: Integer; label_height: Integer; speed: Integer;
  density: Integer; type_tspl: Integer; gap: Integer; offset: Integer): Integer;
function DemText(x_pos: Integer; y_pos: Integer; font: Integer;
  rotation: Integer; x_multiplication: Integer; y_multiplication: Integer;
  content: ansistring): Integer;
function DemBarcode(x_pos: Integer; y_pos: Integer; code_type: Integer;
  height: Integer; readable: Integer; rotation: Integer; narrow: Integer;
  wide: Integer; code_data: ansistring): Integer;
function DemPrint(num: Integer; copies: Integer): Integer;
function DemQrcode(x_pos: Integer; y_pos: Integer; ecc_level: Integer;
  width: Integer; mode: Integer; rotation: Integer; model: Integer;
  mask: Integer; data: ansistring): Integer;
function DemBitmap(x_pos: Integer; y_pos: Integer; mode: Integer;
  filename: ansistring): Integer;
function DemBox(x_start: Integer; y_start: Integer; x_end: Integer;
  y_end: Integer; thickness: Integer): Integer;
function DemDirection(direction: Integer): Integer;
function DemClearbuff(): Integer;
function DemFeed(lines: Integer): Integer;
function DemHome(): Integer;
function DemLearn(): Integer;
function DemGetPrinterStatu(var statu: Integer): Integer;
function DemSetCodePage(codepage: Integer): Integer;
function DemReverse(x_pos:Integer;y_pos:Integer;width:Integer;
  height:Integer):Integer;
function DemGapDetect(paper_length:Integer;gap_length:Integer):Integer;


var
  // Alignment
  ALIGNMENT_LEFT: Integer = 0;
  ALIGNMENT_CENTER: Integer = 1;
  ALIGNMENT_RIGHT: Integer = 2;
  // QR Code Type
  SYMBOL_QRCODE1: Integer = 103;
  SYMBOL_QRCODE2: Integer = 104;
  // Image ScaleMode
  PRINT_IMAGE_NORMAL: Integer = 0;
  PRINT_IMAGE_DOUBLE_WIDTH: Integer = 1;
  PRINT_IMAGE_DOUBLE_HEIGHT: Integer = 2;
  PRINT_IMAGE_QUADRUPLE: Integer = 3;
  // Error Code
  E_SUCCESS: Integer = 0;
  E_BAD_HANDLE: Integer = -6;
  // printer
  printer: Pointer;
  errorNo: Integer = 0;

implementation

function PrinterCreator(printer: PPointer; model: ansistring): Integer; stdcall;
  external 'TSPL_SDK.dll';
function PrinterCreatorS(model: string): Pointer; stdcall;
  external 'TSPL_SDK.dll';
function PortOpen(printer: Pointer; portSetting: ansistring): Integer; stdcall;
  external 'TSPL_SDK.dll';
function PortClose(printer: Pointer): Integer; stdcall; external 'TSPL_SDK.dll';
function PrinterDestroy(printer: Pointer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function DerectIO(printer: Pointer; writedata: PByte; writeNum: Integer;
  readdata: PByte; readNum: Integer; var preadNum: Integer): Integer;
  stdcall; external 'TSPL_SDK.dll';

function TSPL_SelfTest(printer: Pointer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_BitMap(printer: Pointer; x_pos: Integer; y_pos: Integer;
  mode: Integer; filename: ansistring): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Setup(printer: Pointer; label_width: Integer;
  label_height: Integer; speed: Integer; density: Integer; type_tspl: Integer;
  gap: Integer; offset: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_ClearBuffer(printer: Pointer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Box(printer: Pointer; x_start: Integer; y_start: Integer;
  x_end: Integer; y_end: Integer; thickness: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_BarCode(printer: Pointer; x_pos: Integer; y_pos: Integer;
  code_type: Integer; height: Integer; readable: Integer; rotation: Integer;
  narrow: Integer; wide: Integer; code_data: ansistring): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_QrCode(printer: Pointer; x_pos: Integer; y_pos: Integer;
  ecc_level: Integer; width: Integer; mode: Integer; rotation: Integer;
  model: Integer; mask: Integer; data: ansistring): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Text(printer: Pointer; x_pos: Integer; y_pos: Integer;
  font: Integer; rotation: Integer; x_multiplication: Integer;
  y_multiplication: Integer; content: ansistring): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Print(printer: Pointer; num: Integer; copies: Integer): Integer;
  stdcall;
  external 'TSPL_SDK.dll';
function TSPL_FormFeed(printer: Pointer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_SetTear(printer: Pointer; on_off: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_SetRibbon(printer: Pointer; ribbon: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Direction(printer: Pointer; direction: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Feed(printer: Pointer; len: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Home(printer: Pointer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Learn(printer: Pointer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_GetSN(printer: Pointer; var sn:Char): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_GetPrinterStatu(printer: Pointer; var statu: Integer): Integer;
  stdcall;
  external 'TSPL_SDK.dll';
function TSPL_SetCodePage(printer: Pointer; codepage: Integer): Integer; stdcall;
  external 'TSPL_SDK.dll';
function TSPL_Reverse(printer: Pointer;x_pos:Integer;y_pos:Integer;width:Integer;
  height:Integer):Integer;stdcall;
  external 'TSPL_SDK.dll';
function TSPL_GapDetect(printer: pointer;paper_length:Integer;gap_length:Integer):
  Integer;stdcall;
  external 'TSPL_SDK.dll';


function DemPrinterCreator(model: ansistring): Boolean;
begin
  printer := nil;
  errorNo := PrinterCreator(@printer, model);
  if (E_SUCCESS = errorNo) then
  begin
    Result := True;
  end
  else
  begin
    Result := False;
  end;
end;

function DemPortOpen(portSetting: ansistring): Integer;
begin
  if (printer <> PtrToNil) then
  begin
    Result := PortOpen(printer, portSetting);
  end
  else
  begin
    Result := E_BAD_HANDLE;
  end;
end;

function DemPortClose(): Integer;
begin
  Result := PortClose(printer);
  Result := PrinterDestroy(printer);
end;

function DemSelftest(): Integer;
begin
  Result := TSPL_SelfTest(printer);
end;

function DemFormfeed(): Integer;
begin
  Result := TSPL_FormFeed(printer);
end;

function DemText(x_pos: Integer; y_pos: Integer; font: Integer;
  rotation: Integer; x_multiplication: Integer; y_multiplication: Integer;
  content: ansistring): Integer;
begin
  Result := TSPL_Text(printer, x_pos, y_pos, font, rotation, x_multiplication,
    y_multiplication, content);
end;

function DemBarcode(x_pos: Integer; y_pos: Integer; code_type: Integer;
  height: Integer; readable: Integer; rotation: Integer; narrow: Integer;
  wide: Integer; code_data: ansistring): Integer;
begin
  Result := TSPL_BarCode(printer, x_pos, y_pos, code_type, height, readable,
    rotation, narrow, wide, code_data);
end;

function DemPrint(num: Integer; copies: Integer): Integer;
begin
  Result := TSPL_Print(printer, num, copies);
end;

function DemSetup(label_width: Integer; label_height: Integer; speed: Integer;
  density: Integer; type_tspl: Integer; gap: Integer; offset: Integer): Integer;
begin
  Result := TSPL_Setup(printer, label_width, label_height, speed, density,
    type_tspl, gap, offset);
end;

function DemQrcode(x_pos: Integer; y_pos: Integer; ecc_level: Integer;
  width: Integer; mode: Integer; rotation: Integer; model: Integer;
  mask: Integer; data: ansistring): Integer;
begin
  Result := TSPL_QrCode(printer, x_pos, y_pos, ecc_level, width, mode, rotation,
    model, mask, data);
end;

function DemBitmap(x_pos: Integer; y_pos: Integer; mode: Integer;
  filename: ansistring): Integer;
begin
  Result := TSPL_BitMap(printer, x_pos, y_pos, mode, filename);
end;

function DemBox(x_start: Integer; y_start: Integer; x_end: Integer;
  y_end: Integer; thickness: Integer): Integer;
begin
  Result := TSPL_Box(printer, x_start, y_start, x_end, y_end, thickness);
end;

function DemDirection(direction: Integer): Integer;
begin
  Result := TSPL_Direction(printer, direction);
end;

function DemClearbuff(): Integer;
begin
  Result := TSPL_ClearBuffer(printer);
end;

function DemFeed(lines: Integer): Integer;
begin
  Result := TSPL_Feed(printer, lines);
end;

function DemHome(): Integer;
begin
  Result := TSPL_Home(printer);
end;

function DemLearn(): Integer;
begin
  Result := TSPL_Learn(printer);
end;

function DemGetPrinterStatu(var statu: Integer): Integer;
begin
  Result := TSPL_GetPrinterStatu(printer, statu);
end;

function DemSetCodePage(codepage: Integer): Integer;
begin
  Result := TSPL_SetCodePage(printer, codepage);
end;

function DemDerectIO(writedata: PByte; writeNum: Integer;
  readdata: PByte; readNum: Integer; var preadNum: Integer): Integer;
  begin
       Result :=DerectIO(printer,writedata,writeNum,readdata,readNum,preadNum);
  end;

function DemReverse(x_pos:Integer;y_pos:Integer;width:Integer;
  height:Integer):Integer;
begin
  Result :=TSPL_Reverse(printer,x_pos,y_pos,width,height);
end;

function DemGapDetect(paper_length:Integer;gap_length:Integer):Integer;
begin
  result :=TSPL_GapDetect(printer,paper_length,gap_length);
end;

end.
