#include"stdafx.h"
#include"tspl_printer_base.h"
/////////////////////////////////////
//define 
////////////////////////////////////
char* cstringtocharstring(CString str)
{

	int len = WideCharToMultiByte(CP_ACP, 0, str, -1, NULL, 0, NULL, NULL);
	char* ch = new char[len + 1];
	WideCharToMultiByte(CP_ACP, 0, str, -1, ch, len, NULL, NULL);
	return ch;
}
char cstringtochar(CString str)
{
	int len = WideCharToMultiByte(CP_ACP, 0, str, -1, NULL, 0, NULL, NULL);
	char* ch = new char[len + 1];
	WideCharToMultiByte(CP_ACP, 0, str, -1, ch, len, NULL, NULL);
	return ch[0];
}

FormatError                                  DemFormatError;
PrinterCreator                               DemPrinterCreator;
PrinterCreatorS                              DemPrinterCreatorS;
PrinterDestroy                               DemPrinterDestroy;
PortOpen                                     DemPortOpen;
DriverPortOpen                               DemDriverPortOpen;
PortClose                                    DemPortClose;
DirectIO                                     DemDirectIO;

TSPL_SelfTest                                DemSelfTest;
TSPL_BitMap                                  DemBitMap;
TSPL_Setup                                   DemSetup;
TSPL_ClearBuffer                             DemClearBuffer;
TSPL_Box                                     DemBox;
TSPL_BarCode                                 DemBarCode;
TSPL_QrCode                                  DemQrCode;
TSPL_Text                                    DemText;
TSPL_Print                                   DemPrint;
TSPL_FormFeed                                DemFormFeed;
TSPL_SetTear                                 DemSetTear;
TSPL_SetRibbon                               DemSetRibbon;
TSPL_Offset                                  DemOffset;
TSPL_Direction                               DemDirection;
TSPL_Feed                                    DemFeed;
TSPL_Home                                    DemHome;
TSPL_Learn                                   DemLearn;
TSPL_GetSN                                   DemGetSN;
TSPL_GetPrinterStatus                        DemStatus;
TSPL_SetCodePag                              DemCodePag;
TSPL_Reverse                                 DemReverse;
TSPL_GapDetect                               DemGapDetect;


void* hprinter;
HMODULE  m_hDll;

void UnloadDll()
{
	FreeLibrary(m_hDll);
}

BOOL LoadDll()
{
	m_hDll = LoadLibrary(_T("TSPL_SDK.dll"));
	if (m_hDll == 0)
		return FALSE;
	DemFormatError                         = (FormatError)GetProcAddress(m_hDll, "FormatError");
	DemPrinterCreator                      = (PrinterCreator)GetProcAddress(m_hDll, "PrinterCreator");
	DemPrinterCreatorS                     = (PrinterCreatorS)GetProcAddress(m_hDll, "PrinterCreatorS");
	DemDriverPortOpen                      = (DriverPortOpen)GetProcAddress(m_hDll,"DriverPortOpen");
	DemPortClose                           = (PortClose)GetProcAddress(m_hDll, "PortClose");
	DemPortOpen                            = (PortOpen)GetProcAddress(m_hDll, "PortOpen");
	DemPrinterDestroy                      = (PrinterDestroy)GetProcAddress(m_hDll, "PrinterDestroy");
	DemDirectIO                            = (DirectIO)GetProcAddress(m_hDll, "DirectIO");

	DemSelfTest                            = (TSPL_SelfTest)GetProcAddress(m_hDll, "TSPL_SelfTest");
	DemBitMap                              = (TSPL_BitMap)GetProcAddress(m_hDll, "TSPL_BitMap");
	DemSetup                               = (TSPL_Setup)GetProcAddress(m_hDll, "TSPL_Setup");
	DemClearBuffer                         = (TSPL_ClearBuffer)GetProcAddress(m_hDll, "TSPL_ClearBuffer");
	DemBox                                 = (TSPL_Box)GetProcAddress(m_hDll, "TSPL_Box");
	DemBarCode                             = (TSPL_BarCode)GetProcAddress(m_hDll, "TSPL_BarCode");
	DemQrCode                              = (TSPL_QrCode)GetProcAddress(m_hDll, "TSPL_QrCode");
	DemText                                = (TSPL_Text)GetProcAddress(m_hDll, "TSPL_Text");
	DemPrint                               = (TSPL_Print)GetProcAddress(m_hDll, "TSPL_Print");
	DemFormFeed                            = (TSPL_FormFeed)GetProcAddress(m_hDll, "TSPL_FormFeed");
	DemSetTear                             = (TSPL_SetTear)GetProcAddress(m_hDll, "TSPL_SetTear");
	DemSetRibbon                           = (TSPL_SetRibbon)GetProcAddress(m_hDll, "TSPL_SetRibbon");
	DemOffset                              = (TSPL_Offset)GetProcAddress(m_hDll, "TSPL_Offset");
	DemDirection                           = (TSPL_Direction)GetProcAddress(m_hDll, "TSPL_Direction");

	DemFeed                                = (TSPL_Feed)GetProcAddress(m_hDll, "TSPL_Feed");
	DemHome                                = (TSPL_Home)GetProcAddress(m_hDll, "TSPL_Home");
	DemLearn                               = (TSPL_Learn)GetProcAddress(m_hDll, "TSPL_Learn");

	DemGetSN                               = (TSPL_GetSN)GetProcAddress(m_hDll, "TSPL_GetSN");
	DemStatus                              = (TSPL_GetPrinterStatus)GetProcAddress(m_hDll, "TSPL_Status");
	DemCodePag                             = (TSPL_SetCodePag)GetProcAddress(m_hDll, "TSPL_CodePag");
	DemReverse                             = (TSPL_Reverse)GetProcAddress(m_hDll, "TSPL_Reverse");
	DemGapDetect                           = (TSPL_GapDetect)GetProcAddress(m_hDll, "TSPL_GapDetect");

	return TRUE;
}