﻿Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Windows.Forms
Imports System.Drawing
Namespace Printer
    Public Class PrinterState
        Public Shared ReadOnly STS_NORMAL As UInteger = &H0
        Public Shared ReadOnly STS_PAPEREMPTY As UInteger = 1
        Public Shared ReadOnly STS_COVEROPEN As UInteger = 2
        Public Shared ReadOnly STS_PAPERNEAREND As UInteger = 4
        Public Shared ReadOnly STS_MSR_READY As UInteger = 8
        Public Shared ReadOnly STS_SMARTCARD_READY As UInteger = 16
        Public Shared ReadOnly STS_ERROR As UInteger = 32
        Public Shared ReadOnly STS_NOT_OPEN As UInteger = 64
        Public Shared ReadOnly STS_OFFLINE As UInteger = 128
        Private m_status As UInteger = 0
        Public Sub New()
            m_status = 0
        End Sub
        Public Property State() As UInteger
            Get
                Return m_status
            End Get
            Set(ByVal value As UInteger)
                m_status = value
            End Set
        End Property
        Public ReadOnly Property IsNormal() As Boolean
            Get
                Return (STS_NORMAL = m_status)
            End Get
        End Property
        Public ReadOnly Property InError() As Boolean
            Get
                Return (PAPEREMPTY OrElse COVEROPEN OrElse PAPERNEAREND OrElse MSR_READY OrElse SMARTCARD_READY OrElse [ERROR] OrElse NOT_OPEN OrElse OFFLINE)
            End Get
        End Property
        Public ReadOnly Property PAPEREMPTY() As Boolean
            Get
                Return ((STS_PAPEREMPTY And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property COVEROPEN() As Boolean
            Get
                Return ((STS_COVEROPEN And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property PAPERNEAREND() As Boolean
            Get
                Return ((STS_PAPERNEAREND And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property MSR_READY() As Boolean
            Get
                Return ((STS_MSR_READY And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property SMARTCARD_READY() As Boolean
            Get
                Return ((STS_SMARTCARD_READY And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property [ERROR]() As Boolean
            Get
                Return ((STS_ERROR And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property NOT_OPEN() As Boolean
            Get
                Return ((STS_NOT_OPEN And m_status) > 0)
            End Get
        End Property
        Public ReadOnly Property OFFLINE() As Boolean
            Get
                Return ((STS_OFFLINE And m_status) > 0)
            End Get
        End Property
    End Class

    Public Class HPRTPrinter
        Public Const HPRTDIR As String = "TSPL_SDK.dll"
        Public Const charSet As CharSet = charSet.Ansi
        <DllImport(HPRTDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function FormatError(ByVal error_no As Integer, ByVal langid As Integer, ByVal buf As Byte(), ByVal pos As Integer, ByVal bufSize As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PrinterCreator(ByRef printer As IntPtr, ByVal model As String) As Integer
        End Function

        <DllImport(HPRTDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PrinterCreatorS(ByVal model As String) As Point
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PrinterDestroy(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(HPRTDIR, charSet:=charSet, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PortOpen(ByVal printer As IntPtr, ByVal portSetting As String) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function PortClose(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function DirectIO(ByVal printer As IntPtr, ByVal writeData As Byte(), ByVal writenum As Integer, ByVal readData As Byte(), ByVal readNum As Integer, ByRef readedNum As Integer) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_SelfTest(ByVal printer As IntPtr) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_BitMap(ByVal printer As IntPtr, ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal mode As Integer, ByVal filename As String) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Setup(ByVal printer As IntPtr, ByVal label_width As Integer, ByVal label_height As Integer, ByVal speed As Integer, ByVal density As Integer, ByVal type As Integer, ByVal gap As Integer, ByVal offset As Integer) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_ClearBuffer(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Box(ByVal printer As IntPtr, ByVal x_start As Integer, ByVal y_start As Integer, ByVal x_end As Integer, ByVal y_end As Integer, ByVal thickness As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_BarCode(ByVal printer As IntPtr, ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal code_type As Integer, ByVal height As Integer, ByVal readable As Integer, ByVal rotation As Integer, ByVal narrow As Integer, ByVal wide As Integer, ByVal code_data As String) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_QrCode(ByVal printer As IntPtr, ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal ecc_level As Integer, ByVal width As Integer, ByVal mode As Integer, ByVal rotation As Integer, ByVal model As Integer, ByVal mask As Integer, ByVal data As String) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Text(ByVal printer As IntPtr, ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal font As Integer, ByVal rotation As Integer, ByVal x_multiplication As Integer, ByVal y_multiplication As Integer, ByVal content As String) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Print(ByVal printer As IntPtr, ByVal num As Integer, ByVal copies As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_FormFeed(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_SetTear(ByVal printer As IntPtr, ByVal on_off As Integer) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_SetRibbon(ByVal printer As IntPtr, ByVal ribbon As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Offset(ByVal printer As IntPtr, ByVal distance As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Direction(ByVal printer As IntPtr, ByVal directions As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Feed(ByVal printer As IntPtr, ByVal len As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Home(ByVal printer As IntPtr) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Learn(ByVal printer As IntPtr) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_GetSN(ByVal printer As IntPtr, ByVal sn As String) As Integer
        End Function

        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_GetPrinterStatus(ByVal printer As IntPtr, ByRef Statu As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_SetCodePage(ByVal printer As IntPtr, ByVal codepage As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_Reverse(ByVal printer As IntPtr, ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal width As Integer, ByVal height As Integer) As Integer
        End Function
        <DllImport(HPRTDIR, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function TSPL_GapDetect(ByVal printer As IntPtr, ByVal paper_length As Integer, ByVal gap_length As Integer) As Integer
        End Function
        Private printer As IntPtr
        Private langid As Integer = 1
        Private E_SUCCESS As Integer = Constants.E_SUCCESS
        Private E_INVALID_PARAMETER As Integer = Constants.E_INVALID_PARAMETER
        Private state As New PrinterState()
        Private modelname As String = ""
        Public Sub New(ByVal model As String)
            Dim result As Integer = E_SUCCESS
            printer = IntPtr.Zero
            result = PrinterCreator(printer, model)  '创建构造函数
            If E_SUCCESS <> result Then
                Dim errorMsg As String = FormatError(result)
                printer = IntPtr.Zero
                Throw New Exception(errorMsg)
            End If
            modelname = model
        End Sub
        Public Function FormatError(ByVal error_no As Integer) As String
            Dim temp As Byte() = New Byte(512) {}
            FormatError(error_no, langid, temp, 0, 512)
            Return System.Text.Encoding.[Default].GetString(temp, 0, 512)
        End Function
        Public Property Model() As String
            Get
                Return modelname
            End Get
            Set(ByVal value As String)
                If value.ToUpper().Trim() <> modelname.ToUpper().Trim() Then
                    Dim p As IntPtr = IntPtr.Zero
                    If Constants.E_SUCCESS = PrinterCreator(p, value) Then
                        PrinterDestroy(Printer)
                        Printer = p
                        modelname = value
                    End If
                End If
            End Set
        End Property
        Public Function ChangeModel(ByVal modelName As String) As Integer
            Dim result As Integer = Constants.E_SUCCESS
            Return result
        End Function
        Public Function DemPortOpen(ByVal uri As String) As Integer
            If Printer <> IntPtr.Zero Then
                Return PortOpen(Printer, uri)
            Else
                Return Constants.E_BAD_HANDLE
            End If
        End Function




        Public Function DemPortClose() As Integer
            Dim result As Integer = E_SUCCESS
            If Printer <> IntPtr.Zero Then
                result = PortClose(Printer)
                result = PrinterDestroy(Printer)
            End If
            Return result
        End Function


        Public Function DemDirectIO(ByVal writeData As Byte(), ByVal writenum As Integer, ByVal readData As Byte(), ByVal readNum As Integer, ByRef readedNum As Integer) As Integer
            Return DirectIO(Printer, writeData, writenum, readData, readNum, readedNum)
        End Function
        Public Function DemSelfTest() As Integer
            Return TSPL_SelfTest(Printer)
        End Function



        Public Function DemBitMap(ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal mode As Integer, ByVal filename As String) As Integer
            Return TSPL_BitMap(Printer, x_pos, y_pos, mode, filename)
        End Function
        Public Function DemSetup(ByVal label_width As Integer, ByVal label_height As Integer, ByVal speed As Integer, ByVal density As Integer, ByVal type As Integer, ByVal gap As Integer, ByVal offset As Integer) As Integer
            Return TSPL_Setup(Printer, label_width, label_height, speed, density, type, gap, offset)
        End Function
        Public Function DemClearBuffer() As Integer
            Return TSPL_ClearBuffer(Printer)
        End Function
        Public Function DemBox(ByVal x_start As Integer, ByVal y_start As Integer, ByVal x_end As Integer, ByVal y_end As Integer, ByVal thickness As Integer) As Integer
            Return TSPL_Box(Printer, x_start, y_start, x_end, y_end, thickness)
        End Function
        Public Function DemBarCode(ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal code_type As Integer, ByVal height As Integer, ByVal readable As Integer, ByVal rotation As Integer, ByVal narrow As Integer, ByVal wide As Integer, ByVal code_data As String) As Integer
            Return TSPL_BarCode(Printer, x_pos, y_pos, code_type, height, readable, rotation, narrow, wide, code_data)
        End Function
        Public Function DemQrCode(ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal ecc_level As Integer, ByVal width As Integer, ByVal mode As Integer, ByVal rotation As Integer, ByVal model As Integer, ByVal mask As Integer, ByVal data As String) As Integer
            Return TSPL_QrCode(Printer, x_pos, y_pos, ecc_level, width, mode, rotation, model, mask, data)
        End Function
        Public Function DemText(ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal font As Integer, ByVal rotation As Integer, ByVal x_multiplication As Integer, ByVal y_multiplication As Integer, ByVal content As String) As Integer
            Return TSPL_Text(Printer, x_pos, y_pos, font, rotation, x_multiplication, y_multiplication, content)
        End Function
        Public Function DemPrint(ByVal num As Integer, ByVal copies As Integer) As Integer
            Return TSPL_Print(Printer, num, copies)
        End Function
        Public Function DemFormFeed() As Integer
            Return TSPL_FormFeed(Printer)
        End Function
        Public Function DemSetTear(ByVal on_off As Integer) As Integer
            Return TSPL_SetTear(Printer, on_off)
        End Function
        Public Function DemSetRibbon(ByVal ribbon As Integer) As Integer
            Return TSPL_SetRibbon(Printer, ribbon)
        End Function
        Public Function DemOffset(ByVal distance As Integer) As Integer
            Return TSPL_Offset(Printer, distance)
        End Function
        Public Function DemDirection(ByVal directions As Integer) As Integer
            Return TSPL_Direction(Printer, directions)
        End Function
        Public Function DemFeed(ByVal len As Integer) As Integer
            Return TSPL_Feed(Printer, len)
        End Function
        Public Function DemHome() As Integer
            Return TSPL_Home(Printer)
        End Function
        Public Function DemLearn() As Integer
            Return TSPL_Learn(Printer)
        End Function

        Public Function DemGetSN(ByVal sn As String) As Integer
            Return TSPL_GetSN(Printer, sn)
        End Function

        Public Function DemGetPrinterStatus(ByRef status As Integer) As Integer
            Return TSPL_GetPrinterStatus(Printer, status)
        End Function

        Public Function DemSetCodePage(ByVal codepage As Integer) As Integer
            Return TSPL_SetCodePage(Printer, codepage)
        End Function

        Public Function DemReverse(ByVal x_pos As Integer, ByVal y_pos As Integer, ByVal width As Integer, ByVal height As Integer) As Integer
            Return TSPL_Reverse(printer, x_pos, y_pos, width, height)
        End Function

        Public Function DemGapDetect(ByVal paper_length As Integer, ByVal gap_length As Integer) As Integer
            Return TSPL_GapDetect(Printer, paper_length, gap_length)
        End Function


    End Class
End Namespace