#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
//#include "sdk_common_api.h"

typedef int (*pPrinterCreator)(void** handle,const char* );

typedef int (*pPrinterDestroy)(void* handle);

typedef int (*pPortOpen)(void* handle,const char* );

typedef int (*pFormatError)(int errorNO,int ,unsigned char*,int,int);

typedef int (*pPortClose)(void* handle);

typedef int (*pZPL_Text)(void* handle,int,int,int,int,int,int,const char*);

typedef int (*pZPL_StartFormat)(void* handle);

typedef int (*pZPL_EndFormat)(void* handle);

typedef int (*pZPL_GetPrinterStatus)( void* handle, int* Status );

typedef int (*pZPL_SetPrintDarkness)( void* handle, int darkness );

typedef int (*pZPL_SetPrintOrientation)( void* handle, int orientation );

typedef int (*pZPL_PrintImage)(void* handle,int xPos,int yPos,const char*imgName);

typedef int  (*pZPL_Pdf417)( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int securityLevel, int columns, int rows, char truncate, const char* text );

typedef int (*pZPL_CodeEan8)( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const char* text );

typedef int (*pZPL_BarCode39)( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const char* text );


typedef int (*pZPL_UpcaBarcode)( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const char* text );

typedef int (*pZPL_UpcExtensions)( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const char* text );

typedef int (*pZPL_GraphicCircle)( void* handle, int xPos, int yPos, int diameter, int thickness);

typedef int (*pZPL_QRCode)( void* handle, int xPos, int yPos, int orientation, int model, int dpi, char eccLevel,char input, char charMode, const char* text );

typedef int (*pZPL_GraphicEllipse)( void* handle, int xPos, int yPos, int width, int height, int thickness );

typedef int (*pZPL_GraphicDiagonalLine)( void* handle, int xPos, int yPos, int orientation, int width, int height, int thickness );

typedef int (*pZPL_GraphicBox)( void* handle, int xPos, int yPos, int width, int height, int thickness, int rounding );

typedef int (*pZPL_GraphicSymbol)( void* handle, int xPos, int yPos, int orientation, int width, int height, const char* symbol );


void Test_zpl()
{	

	void *phandle = NULL;
 	int status = 0; 
	int result = 0;
	char error_msg[1024] = {0};
	void* handle = dlopen("./libzpl_sdk.so",RTLD_LAZY);
	if(!handle)
	{
		printf("Failed to load shared library.\r\n");
		return; 	
	}
	else
	{
		printf("Load successed.\r\n");
	}

	pPrinterCreator PrinterCreator = (pPrinterCreator)dlsym(handle,"PrinterCreator");
	pPrinterDestroy PrinterDestroy = (pPrinterDestroy)dlsym(handle,"PrinterDestroy");
	pPortOpen PortOpen = (pPortOpen)dlsym(handle,"PortOpen");
	pPortClose PortClose = (pPortClose)dlsym(handle,"PortClose");
	pFormatError FormatError = (pFormatError)dlsym(handle,"FormatError");

	pZPL_Text ZPL_Text = (pZPL_Text)dlsym(handle,"ZPL_Text");
	pZPL_StartFormat ZPL_StartFormat = (pZPL_StartFormat)dlsym(handle,"ZPL_StartFormat");
	pZPL_EndFormat ZPL_EndFormat = (pZPL_EndFormat)dlsym(handle,"ZPL_EndFormat");

	pZPL_GetPrinterStatus ZPL_GetPrinterStatus = (pZPL_GetPrinterStatus)dlsym(handle,"ZPL_GetPrinterStatus");
	pZPL_SetPrintDarkness ZPL_SetPrintDarkness = (pZPL_SetPrintDarkness)dlsym(handle,"ZPL_SetPrintDarkness");
	pZPL_SetPrintOrientation ZPL_SetPrintOrientation = (pZPL_SetPrintOrientation)dlsym(handle,"ZPL_SetPrintOrientation");
	pZPL_PrintImage ZPL_PrintImage = (pZPL_PrintImage)dlsym(handle,"ZPL_PrintImage");
	pZPL_Pdf417 ZPL_Pdf417 = (pZPL_Pdf417)dlsym(handle,"ZPL_Pdf417");
	pZPL_CodeEan8 ZPL_CodeEan8 = (pZPL_CodeEan8)dlsym(handle,"ZPL_CodeEan8");
	pZPL_BarCode39 ZPL_BarCode39 = (pZPL_BarCode39)dlsym(handle,"ZPL_BarCode39");
	pZPL_UpcaBarcode ZPL_UpcaBarcode = (pZPL_UpcaBarcode)dlsym(handle,"ZPL_UpcaBarcode");
	pZPL_UpcExtensions ZPL_UpcExtensions = (pZPL_UpcExtensions)dlsym(handle,"ZPL_UpcExtensions");
	pZPL_GraphicCircle ZPL_GraphicCircle = (pZPL_GraphicCircle)dlsym(handle,"ZPL_GraphicCircle");

	pZPL_GraphicEllipse ZPL_GraphicEllipse = (pZPL_GraphicEllipse)dlsym(handle,"ZPL_GraphicEllipse");
	pZPL_GraphicSymbol ZPL_GraphicSymbol = (pZPL_GraphicSymbol)dlsym(handle,"ZPL_GraphicSymbol");

	pZPL_QRCode ZPL_QRCode = (pZPL_QRCode)dlsym(handle,"ZPL_QRCode");
	pZPL_GraphicDiagonalLine ZPL_GraphicDiagonalLine = (pZPL_GraphicDiagonalLine)dlsym(handle,"ZPL_GraphicDiagonalLine");
	pZPL_GraphicBox ZPL_GraphicBox = (pZPL_GraphicBox)dlsym(handle,"ZPL_GraphicBox");

	//result = PrinterCreator(&phandle, "HT130");
	//result = PrinterCreator(&phandle, "CP30");
	result = PrinterCreator(&phandle, "HM-T300PRO");
	if (0 != result)
	{
	  FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
	  printf("Creation fail:%s\n", error_msg);
       	  return;
  	}
	else
	{
		printf("Creation successed\r\n");
	}

	result = PortOpen(phandle, "USB,iT4E,vid=0x20D1,pid=0x7007");//based on device change 
	//result = PortOpen(phandle, "COM,ttyUSB0,BAUDRATE=115200");
	//result = PortOpen(phandle, "COM=ttyUSB0,BAUDRATE=115200");
	printf("PortOpen result= %d\r\n",result);
	
	if (0 != result)
	{
	  FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
	  printf("%s\n", error_msg);
	}
	else
	{
		//printf("Open successed\n");
		//ZPL_StartFormat(phandle);
		//ZPL_Text(phandle,200,100,16,0,40,40,"2023/5/23 ZPLTEXT");
		//ZPL_EndFormat(phandle);
	
	result = ZPL_GetPrinterStatus(phandle,&status);
        printf("status = %d\n", status);

        result = ZPL_StartFormat(phandle);

        result = ZPL_SetPrintDarkness(phandle, 30);

        result = ZPL_SetPrintOrientation(phandle,0);

        result = ZPL_PrintImage(phandle, 100, 30, "/home/liu/Documents/1-x.bmp");

        result = ZPL_Pdf417(phandle, 100, 100, 0, 2, 20, 2, 5, 5, 'N', "0010101101");

        result = ZPL_CodeEan8(phandle, 500, 100, 0, 3, 60, 'Y', 'Y', "90381010");
    
        result = ZPL_BarCode39(phandle, 100, 400, 0, 3, 50, 'Y', 'Y', 'Y', "66886868");
        
        result = ZPL_UpcaBarcode(phandle, 400, 250, 0, 3, 50, 'Y', 'Y', 'N', "47631664454");
       
        result = ZPL_UpcExtensions(phandle, 100, 250, 0, 3, 50, 'Y', 'Y', "01234");
        
	result = ZPL_QRCode(phandle, 100, 800, 0, 1, 3, 'M','M','N', "1000000001");
        
        result = ZPL_Text(phandle, 100, 500, 16, 0, 40, 40, "hello");
        
        result = ZPL_GraphicCircle(phandle, 350, 500, 150, 5);
        
        result = ZPL_GraphicEllipse(phandle, 500, 500, 150, 100, 10);
         
	result = ZPL_GraphicDiagonalLine(phandle, 500, 1000, 0x52, 50, 50, 20);
             
        result = ZPL_GraphicBox(phandle, 100, 1200, 100, 100, 60, 3);
        
        result = ZPL_GraphicSymbol(phandle, 300, 1200, 0, 200, 200, "A");
       
        result = ZPL_EndFormat(phandle);

	}
	if(!result)
	{
		printf("ZPLTest success");	
	}
	else
	{       
		printf("ZPLTest fail");
	}
	
}


int main()
{

    //FontDownTest();
    Test_zpl();
    return 0;
}
